/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.application;

import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.CliReturn_EN;
import com.mmm.cms.hh.pdgm.grouper.GrouperFactory;
import com.mmm.cms.hh.pdgm.grouper.GrouperFactoryIF;
import com.mmm.cms.hh.pdgm.grouper.GrouperIF;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HHPDGMGrouper {
    private static final Logger LOG = Logger.getLogger(HHPDGMGrouper.class.getName());
    private static final String CMD_LINE_DESIRED_FORMAT_MSG = "Required argument: <Input File/Record>, optional: <Full output record>: -f, (arguments are positional)";
    private static GrouperFactoryIF GROUPER_FACTORY = null;
    private static final String FILE_OUT_SUFFIX = "_OUT";
    private static final String TEST_OUTPUT = "AA.A.AABBBBBCCDD";
    private static File inputFile;
    private static File outputFile;
    private static boolean fullRecord;

    public static final ClaimContainerIF getEmptyClaim(String claimDate) {
        return HHPDGMGrouper.getGrouperFactory().getEmptyClaim(claimDate);
    }

    public static final boolean isClaimDateValid(String claimDate) {
        return HHPDGMGrouper.getGrouperFactory().isClaimDateValid(claimDate);
    }

    public static final String getDiagnosisDescription(String claimDate, String diagValue) {
        return HHPDGMGrouper.getGrouperFactory().getDiagnosisDescription(claimDate, diagValue);
    }

    public static final String getBuildInfo() {
        return HHPDGMGrouper.getGrouperFactory().getBuildInfo();
    }

    public static final void group(ClaimContainerIF claim) {
        HHPDGMGrouper.getGrouperFactory().group(claim);
    }

    public static final List<GrouperIF> getAvailableVersions() {
        return HHPDGMGrouper.getGrouperFactory().getAvailableVersions();
    }

    public static final GrouperIF getDefaultGrouper() {
        return HHPDGMGrouper.getGrouperFactory().getDefaultGrouper();
    }

    public static final void group(File input, File output) {
        HHPDGMGrouper.getGrouperFactory().group(input, output);
    }

    public static final void group(File input, File output, boolean fullRecord) {
        HHPDGMGrouper.getGrouperFactory().group(input, output, fullRecord);
    }

    public static final String groupTest(String claimInput) {
        return TEST_OUTPUT;
    }

    public static final String group(String claimInput) {
        return HHPDGMGrouper.getGrouperFactory().group(claimInput);
    }

    public static final String group(String claimInput, boolean fullRecord) {
        return HHPDGMGrouper.getGrouperFactory().group(claimInput, fullRecord);
    }

    public static void main(String[] args) {
        LOG.info(HHPDGMGrouper.getBuildInfo());
        CliReturn_EN ret = HHPDGMGrouper.processCmdLineArgs(args);
        if (ret == CliReturn_EN.RUN_NOTHING) {
            return;
        }
        if (ret == CliReturn_EN.RUN_FILE) {
            HHPDGMGrouper.group(inputFile, outputFile, fullRecord);
        }
        if (ret == CliReturn_EN.RUN_RECORD) {
            String input = inputFile.getName();
            String output = HHPDGMGrouper.group(input, fullRecord);
            System.out.print(output);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CliReturn_EN processCmdLineArgs(String[] args) {
        if (args.length <= 0) {
            LOG.severe(CMD_LINE_DESIRED_FORMAT_MSG);
            return CliReturn_EN.RUN_NOTHING;
        }
        block4: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (i) {
                case 0: {
                    inputFile = new File(arg);
                    continue block4;
                }
                case 1: {
                    if (!arg.equalsIgnoreCase("-f")) continue block4;
                    fullRecord = true;
                    continue block4;
                }
                default: {
                    LOG.log(Level.WARNING, "Unknown parameter: {0}", args[i]);
                }
            }
        }
        if (inputFile.exists()) {
            outputFile = HHPDGMGrouper.getOutputFile(inputFile);
            LOG.log(Level.INFO, "Grouping: input file=<{0}>, output file=<{1}>, full record format=<{2}>", new Object[]{inputFile.getPath(), outputFile.getPath(), fullRecord});
            return CliReturn_EN.RUN_FILE;
        }
        String input = inputFile.getName();
        if (input.trim().isEmpty()) {
            LOG.log(Level.SEVERE, "Input file/record is empty");
            return CliReturn_EN.RUN_NOTHING;
        }
        LOG.log(Level.INFO, "Could not find input file:\n''{0}''\nWill try to process it as a record.", input);
        return CliReturn_EN.RUN_RECORD;
    }

    private static File getOutputFile(File file) {
        String fileName = file.getPath();
        int pos = fileName.lastIndexOf(46);
        String fileOut = pos > 0 && pos < fileName.length() - 1 ? fileName.substring(0, pos) + FILE_OUT_SUFFIX + fileName.substring(pos) : fileName + FILE_OUT_SUFFIX;
        return new File(fileOut);
    }

    private static GrouperFactoryIF getGrouperFactory() {
        if (GROUPER_FACTORY == null) {
            GROUPER_FACTORY = GrouperFactory.getInstance();
        }
        return GROUPER_FACTORY;
    }
}

