/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.grouper;

import com.mmm.cms.hh.pdgm.claim.ClaimAdapter;
import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.claim.HippsCode;
import com.mmm.cms.hh.pdgm.claim.ReturnCode;
import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainer;
import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ReturnCodeContainer;
import com.mmm.cms.hh.pdgm.data.exchange.ValidityFlagContainer;
import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.ActionFlag_EN;
import com.mmm.cms.hh.pdgm.grouper.ClaimManager;
import com.mmm.cms.hh.pdgm.grouper.ClaimManagerIF;
import com.mmm.cms.hh.pdgm.grouper.DataContainerIF;
import com.mmm.cms.hh.pdgm.grouper.DataManager;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;
import com.mmm.cms.hh.pdgm.grouper.GrouperIF;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionIterator;
import com.mmm.cms.hh.pdgm.logic.processor.HippsProcessor;
import com.mmm.cms.hh.pdgm.reference.objects.ClaimObject;
import com.mmm.cms.hh.pdgm.reference.objects.GrouperVersionObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractGrouper
implements GrouperIF {
    private static final Logger LOG = Logger.getLogger(AbstractGrouper.class.getName());
    DataManagerIF dataManager;
    ClaimManagerIF claimManager;
    HippsProcessor hippsProcessor;
    private int id;
    private String name;
    private String description;
    private boolean active;
    private Date startDate;
    private Date endDate;
    private boolean defaultFlag;

    @Override
    public List<Integer> getClaimLayout() {
        return this.claimManager.getClaimLayout();
    }

    @Override
    public List<Integer> getClaimLayoutInputOnly() {
        return this.claimManager.getClaimLayoutInputOnly();
    }

    @Override
    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = new Date(startDate.getTime());
    }

    @Override
    public Date getEndDate() {
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = new Date(endDate.getTime());
    }

    public AbstractGrouper(int id, String name, String description, String startDate, String endDate, boolean active, boolean defaultt) throws ParseException {
        this.id = id;
        this.name = name;
        this.description = description;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.startDate = sdf.parse(startDate);
        this.endDate = sdf.parse(endDate);
        this.active = active;
        this.defaultFlag = defaultt;
        this.dataManager = new DataManager(this.buildRtBasePath(), true);
        this.claimManager = new ClaimManager(this.buildClaimLayoutPath());
        LOG.log(Level.INFO, "Grouper version {0} instantiated", this.name);
    }

    private String buildRtBasePath() {
        String retPath = "Versions/" + this.name.replaceAll("\\.", "") + "/RT";
        return retPath;
    }

    private String buildClaimLayoutPath() {
        String retPath = "Versions/" + this.name.replaceAll("\\.", "");
        return retPath;
    }

    public AbstractGrouper(Integer id, GrouperVersionObject grouperVersionObject) throws ParseException {
        this(id, grouperVersionObject.getId(), grouperVersionObject.getDescription(), grouperVersionObject.getStartDate(), grouperVersionObject.getEndDate(), Integer.parseInt(grouperVersionObject.getActiveFlag()) > 0, Integer.parseInt(grouperVersionObject.getDefaultFlag()) > 0);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void setDefault(boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    @Override
    public ClaimContainerIF getEmptyClaim() {
        return new ClaimContainer();
    }

    @Override
    public void group(ClaimContainerIF claimInput) {
        ClaimIF claim = new ClaimAdapter().convert(claimInput);
        this.group(claim);
        claimInput.setVersionUsed(claim.getGrouperVersion());
        claimInput.setHippsCode(claim.getHippsCode().getFinalHippsCode());
        claimInput.setValidityFlag(new ValidityFlagContainer(claim.getSingleValidityFlag().getValue(), claim.getSingleValidityFlag().getDescription()));
        claimInput.setReturnCode(new ReturnCodeContainer(String.format("%02d", claim.getSingleReturnCode().getId()), claim.getSingleReturnCode().getDescription()));
        claimInput.setEdits(claim.getClaimEdits());
    }

    protected void group(ClaimIF claim) {
        int GRC_INTERNAL_ERROR = 50;
        if (claim == null) {
            return;
        }
        try {
            this.hippsProcessor = new HippsProcessor(claim, this.dataManager);
            this.hippsProcessor.process(new HippsPositionIterator());
            claim.setGrouperVersion(this.getVersion());
        }
        catch (Exception e) {
            claim.getReturnCodes().clear();
            claim.getReturnCodes().add(new ReturnCode(50, "Grouper Internal Error"));
            claim.setHippsCode(new HippsCode());
            claim.setGrouperVersion(this.getVersion());
            System.out.println("*** SEVERE: Grouper Internal Error with processing claim ***");
            claim.getClaimEdits().getEdits().forEach(edit -> System.out.println(edit));
        }
    }

    @Override
    public String group(String claimInput) {
        ClaimObject claimIn = this.claimManager.loadClaim(claimInput);
        ClaimIF claim = new ClaimAdapter().convert(claimIn);
        this.group(claim);
        String retStr = this.formatResult(claim);
        claimIn.setVersionUsed(claim.getGrouperVersion());
        claimIn.setHippsCode(claim.getHippsCode().getHippsCode());
        claimIn.setByPosition(55, claim.getSingleValidityFlag().getValue());
        claimIn.setByPosition(56, String.format("%02d", claim.getSingleReturnCode().getId()));
        if (claimIn.getOptions().getActionFlag().equalsIgnoreCase(ActionFlag_EN.Y.name())) {
            System.out.println("*** Grouping Detail Report ***");
            System.out.println(claimIn);
            System.out.println("*** Output string = " + retStr);
            claim.getClaimEdits().getEdits().forEach(edit -> System.out.println(edit));
        }
        return retStr;
    }

    protected String formatResult(ClaimIF claim) {
        String retStr = this.getVersion() + claim.getHippsCode().getFinalHippsCode() + claim.getSingleValidityFlag().getValue() + String.format("%02d", claim.getSingleReturnCode().getId());
        return retStr;
    }

    @Override
    public String getVersion() {
        return this.getName();
    }

    @Override
    public DataContainerIF<PositionAccessorIF> getAvailableTableContent(TableNames_EN tableType) {
        return this.dataManager.getDataMap().get(tableType);
    }
}

