/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.logic.processor;

import com.mmm.cms.hh.pdgm.claim.ClaimElementCollectionIF;
import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditType_EN;
import com.mmm.cms.hh.pdgm.diagnosis.ClinicalGroup;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionAbstract;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionIF;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionSelectorIF;
import com.mmm.cms.hh.pdgm.logic.validation.Edit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HippsPosition2
extends HippsPositionAbstract
implements HippsPositionIF {
    private static final Logger LOG = Logger.getLogger(HippsPosition2.class.getName());

    public HippsPosition2(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    @Override
    public void process(HippsPositionSelectorIF visitor) {
        visitor.select(this);
    }

    @Override
    public boolean validate() {
        this.validateDiagnoses();
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        if (this.checkAsPdx("PDX", pdx)) {
            DiagnosisIF diag;
            ClaimElementCollectionIF<DiagnosisIF> sdxList = this.getClaim().getSecondaryDiagnoses();
            if (!sdxList.isEmpty() && (diag = (DiagnosisIF)sdxList.get(0)).isPrimaryAwarding() && this.checkAsPdx("SDX1 as PDX", diag)) {
                this.getClaim().setPrimaryDiagnosis(diag);
                sdxList.remove(0);
                this.getClaim().getPrimaryDiagnosis().addEdit(new Edit(EditId_EN.VALUE_SUBSTITUTED, pdx + " " + EditId_EN.VALUE_SUBSTITUTED.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean calculate() {
        int HIPPS_POSITION = 2;
        String text = null;
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        if (!pdx.getEditCollection().hasCriticalEdits()) {
            text = "PDX = " + pdx.getValue() + " (" + pdx.getDescription() + ")" + (pdx.getEditCollection().hasEditId(EditId_EN.VALUE_SUBSTITUTED) ? " (Primary awarded SDX1)" : "");
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "PDX Clincal Group = " + pdx.getClinicalGroup();
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "PDX Subchapter = " + pdx.getDiagnosisSubchapter().getDxFrom() + "-" + pdx.getDiagnosisSubchapter().getDxTo() + " (" + pdx.getDiagnosisSubchapter().getDescription() + ")";
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "HIPPS Position 2 = " + pdx.getClinicalGroup().getValue() + " (" + pdx.getClinicalGroup().getDescription() + ")";
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            return this.setHippsCode(2, "" + pdx.getClinicalGroup().getValue());
        }
        text = "PDX has critical issue(s). Please see validation messages";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
        text = "HIPPS Position 2 = 0 (Not calculated)";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
        return false;
    }

    private boolean checkAsPdx(String label, DiagnosisIF pdx) {
        int GRC_INVALID_PDX = 3;
        int GRC_UNGROUPABLE_PDX = 5;
        boolean retFlag = true;
        if (!pdx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID)) {
            ClinicalGroup cg = pdx.getClinicalGroup();
            if (cg == null || cg.getValue().isEmpty() || cg.getValue().equalsIgnoreCase("n/a")) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " has no Clinical Group assigned, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isManifestation()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is manifestation DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isECOI()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is ECOI DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
        } else {
            this.addReturnCode(3);
            retFlag = false;
        }
        return retFlag;
    }
}

