/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.DxContainerIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.Oasis_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.PeriodTiming_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.ReferralSource_EN;
import com.mmm.cms.hh.pdgm.diagnosis.Diagnosis;
import java.util.List;
import java.util.Map;

/**
 *
 * @author US340646
 */
public class ClaimAdapter {

    // Convert claim container (PC API) to internal claim format

    /**
     *
     * @param claimIn
     * @return
     */
    public ClaimIF convert(ClaimContainerIF claimIn) {

        Claim retClaim = new Claim();

        // ID
        retClaim.setClaimId(claimIn.getClaimId());

        // From Date
        DateFrom df = new DateFrom();
        df.setValue(claimIn.getFromDate());
        retClaim.setDateFrom(df);

        // Period Timing
        PeriodTiming pt = new PeriodTiming();
        String ptVal = claimIn.getPeriodTiming();
        pt.setValue(ptVal);
        // get Period Timing Description
        pt.setDescription(getPeriodTimingDescription(ptVal));
        retClaim.setPeriodTiming(pt);

        // Referral Source
        ReferralSource rf = new ReferralSource();
        String rfVal = claimIn.getReferralSource();
        rf.setValue(rfVal);
        // get Referral Source Description
        rf.setDescription(getReferralSourceDescription(rfVal));
        retClaim.setReferralSource(rf);

        // PDX
        Diagnosis pdx = new Diagnosis(); // Instantiate "shallow" internal DX object
        if (claimIn.getPdx() != null) {
            pdx.setValue(claimIn.getPdx().getDx().trim().toUpperCase());
        }
        retClaim.setPrimaryDiagnosis(pdx);

        // SDX
        List<DxContainerIF> sdxList = claimIn.getSdxList();
        if (sdxList != null) {
            for (DxContainerIF dx : sdxList) {
                if (dx == null || dx.getDx().trim().isEmpty()) {
                    break; // terminate on blank SDX
//                    continue; // skip blank SDX
                }
                Diagnosis sdx = new Diagnosis();
                sdx.setValue(dx.getDx().trim().toUpperCase());
                retClaim.getSecondaryDiagnoses().add(sdx);
            }
        }

        // OASIS
        Map<String, String> ffMap = claimIn.getFunctionalFields();
        for (Map.Entry<String, String> entry : ffMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            OasisResponse oasisResponse = new OasisResponse();
            oasisResponse.setType(Oasis_EN.valueOf(key));
            oasisResponse.setValue(value);
            retClaim.getOasisFields().add(oasisResponse);
        }

        return retClaim;
    }

    private String getPeriodTimingDescription(String inValue) {
        if (inValue == null) {
            return null;
        }
        for (PeriodTiming_EN value : PeriodTiming_EN.values()) {
            if (("" + value.getId()).equalsIgnoreCase(inValue.trim())) {
                return value.getDescription();
            }
        }
        return null;
    }

    private String getReferralSourceDescription(String inValue) {
        if (inValue == null) {
            return ReferralSource_EN.OTHER.getDescription();
        }
        for (ReferralSource_EN value : ReferralSource_EN.values()) {
            if (("" + value.getId()).equalsIgnoreCase(inValue.trim())) {
                return value.getDescription();
            }
        }
        return ReferralSource_EN.OTHER.getDescription();
    }

}
