/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.common.abstr.EditableIF;
import com.mmm.cms.hh.pdgm.common.abstr.VerifiableIF;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollection;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;
import com.mmm.cms.hh.pdgm.logic.validation.EditIF;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author US340646
 */
public class ClaimElementBase implements EditableIF, VerifiableIF, Serializable{

    private static final long serialVersionUID = 1L;
    
    private EditCollectionIF edits = new EditCollection();
    private boolean verified;
    
        /**
     * @return the edits
     */
    @Override
    public EditCollectionIF getEditCollection() {
        return edits;
    }

    /**
     * @param edits the edits to set
     */
    public void setEdits(EditCollectionIF edits) {
        this.edits = edits;
    }

    /**
     *
     * @param edits
     */
    @Override
    public void addEdits(List<EditIF> edits) {
        this.edits.addEdits(edits);
    }

    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        edits.addEdit(edit);
    }

    /**
     * @return the verified
     */
    @Override
    public boolean isVerified() {
        return verified;
    }

    /**
     * @param verified the verified to set
     */
    @Override
    public void setVerified(boolean verified) {
        this.verified = verified;
    }

}
