/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.data.meta.enumer.Oasis_EN;

/**
 *
 * @author us340646
 */
public class OasisResponse extends ClaimElementBase implements OasisResponseIF {

    private static final long serialVersionUID = 1L;

    @Override
    public String toString() {
        return "OasisResponse{" + "type="
                + (type != null ? type.name() : "Unknown") + ", value="
                + value + ", score="
                + score + '}';
    }

    /**
     * @return the type
     */
    @Override
    public Oasis_EN getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    @Override
    public void setType(Oasis_EN type) {
        this.type = type;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }
    private Oasis_EN type;
    private String value;
    private int score;

    /**
     * @return the score
     */
    @Override
    public int getScore() {
        return score;
    }

    /**
     * @param score the score to set
     */
    @Override
    public void setScore(int score) {
        this.score = score;
    }

}
