/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.data.meta.enumer;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;

/**
 *
 * @author us340646
 */
public enum ReferralSource_EN implements DescribableIF, IdentifiableIF {

    // Claim Period Timing

    /**
     *
     */
    OTHER(0,"Community"),
    
    /**
     *
     */
    ACUTE_HOSPITAL(61,"Acute Hospital - Institutional"),

    /**
     *
     */
    SNF_OR_OTHER(62,"SNF or other - Institutional")
    ;
    
    private String description;
    private int id;

    private ReferralSource_EN(int id, String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

}
