/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.diagnosis;

import com.mmm.cms.hh.pdgm.claim.ClaimElementBase;
import com.mmm.cms.hh.pdgm.reference.objects.DiagnosisObject;

/**
 *
 * @author US340646
 */
public class Diagnosis extends ClaimElementBase implements DiagnosisIF {

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "Diagnosis{" + "id=" + id + ", value=" + value + ", description=" 
                + description + ", manifestation=" + manifestation 
                + ", primaryAwarding=" + primaryAwarding + ", ECOI=" + ECOI 
                + ", clinicalGroup=" + clinicalGroup + ", comorbidityGroup=" 
                + comorbidityGroup + ", diagnosisSubchapter=" + diagnosisSubchapter + '}';
    }

    /**
     * Constructor
     */
    public Diagnosis() {
    }

    /**
     *
     * @param id
     * @param value
     * @param description
     * @param manifestation
     * @param primaryAwarding
     * @param ECOI
     * @param clinicalGroup
     * @param comorbidityGroup
     * @param diagnosisSubchapter
     */
    public Diagnosis(int id,
            String value,
            String description,
            boolean manifestation,
            boolean primaryAwarding,
            boolean ECOI,
            ClinicalGroup clinicalGroup,
            ComorbidityGroup comorbidityGroup,
            DiagnosisSubchapter diagnosisSubchapter) {
        this.id = id;
        this.value = value;
        this.description = description;
        this.manifestation = manifestation;
        this.primaryAwarding = primaryAwarding;
        this.ECOI = ECOI;
        this.clinicalGroup = clinicalGroup;
        this.comorbidityGroup = comorbidityGroup;
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

    /**
     *
     * @param id
     * @param diagObj
     * @param clinicalGroup
     * @param comorbidityGroup
     * @param diagnosisSubchapter
     */
    public Diagnosis(int id,
            DiagnosisObject diagObj,
            ClinicalGroup clinicalGroup,
            ComorbidityGroup comorbidityGroup,
            DiagnosisSubchapter diagnosisSubchapter) {
        this(id,
                diagObj.getValue(),
                diagObj.getDescription(),
                Integer.parseInt(diagObj.getManifestationFlag()) > 0,
                Integer.parseInt(diagObj.getPrimaryAwardingFlag()) > 0,
                Integer.parseInt(diagObj.getEcoiFlag()) > 0,
                clinicalGroup,
                comorbidityGroup,
                diagnosisSubchapter
        );

    }

    /**
     * @return the clinicalGroup
     */
    @Override
    public ClinicalGroup getClinicalGroup() {
        return clinicalGroup;
    }

    /**
     * @param clinicalGroup the clinicalGroup to set
     */
    @Override
    public void setClinicalGroup(ClinicalGroup clinicalGroup) {
        this.clinicalGroup = clinicalGroup;
    }

    /**
     * @return the comorbidityGroup
     */
    @Override
    public ComorbidityGroup getComorbidityGroup() {
        return comorbidityGroup;
    }

    /**
     * @param comorbidityGroup the comorbidityGroup to set
     */
    @Override
    public void setComorbidityGroup(ComorbidityGroup comorbidityGroup) {
        this.comorbidityGroup = comorbidityGroup;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the manifestation
     */
    @Override
    public boolean isManifestation() {
        return manifestation;
    }

    /**
     * @param manifestation the manifestation to set
     */
    @Override
    public void setManifestation(boolean manifestation) {
        this.manifestation = manifestation;
    }

    /**
     * @return the primaryAwarding
     */
    @Override
    public boolean isPrimaryAwarding() {
        return primaryAwarding;
    }

    /**
     * @param primaryAwarding the primaryAwarding to set
     */
    @Override
    public void setPrimaryAwarding(boolean primaryAwarding) {
        this.primaryAwarding = primaryAwarding;
    }

    /**
     * @return the ECOI
     */
    @Override
    public boolean isECOI() {
        return ECOI;
    }

    /**
     * @param ECOI the ECOI to set
     */
    @Override
    public void setECOI(boolean ECOI) {
        this.ECOI = ECOI;
    }

    private int id;
    private String value;
    private String description;
    private boolean manifestation;
    private boolean primaryAwarding;
    private boolean ECOI;
    private ClinicalGroup clinicalGroup;
    private ComorbidityGroup comorbidityGroup;
    private DiagnosisSubchapter diagnosisSubchapter;

    /**
     * @return the diagnosisSubchapter
     */
    @Override
    public DiagnosisSubchapter getDiagnosisSubchapter() {
        return diagnosisSubchapter;
    }

    /**
     * @param diagnosisSubchapter the diagnosisSubchapter to set
     */
    @Override
    public void setDiagnosisSubchapter(DiagnosisSubchapter diagnosisSubchapter) {
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

}
