/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.processor;

import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;

/**
 *
 * @author us340646
 */
public class HippsPosition5 extends HippsPositionAbstract implements HippsPositionIF {

    /*
    * 5. HIPPS 5th position
     */

    /**
     *
     * @param claim
     * @param dataManager
     */

    public HippsPosition5(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    /**
     *
     * @param visitor
     */
    @Override
    public void process(HippsPositionSelectorIF visitor) {
        visitor.select(this);
    }

    /**
     *
     * @return
     */
    @Override
    public boolean validate() {
        return getClaim().getHippsCode().isHippsComplete();
    }

    /**
     *
     * @return
     */
    @Override
    public boolean calculate() {

        final int HIPPS_POSITION = 5;
        
        final int GRC_OK = 0;

        // add "0" GRC if success
        if(getClaim().getHippsCode().isHippsComplete()) {
            addReturnCode(GRC_OK);
        }

        addHippsLogicMessage(EditId_EN.VALUE_HIPPS5, "HIPPS Position 5 = 1 (filler)");
        
        // Set HIPPS 5
        return setHippsCode(HIPPS_POSITION, "" + 1);
        
    }

}
