/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification;

import com.mmm.cms.hh.pdgm.claim.OasisResponseIF;
import com.mmm.cms.hh.pdgm.logic.specification.abstr.AbstractSpecification;
import com.mmm.cms.hh.pdgm.reference.objects.OasisRespondObject;

/**
 *
 * @author US340646
 */
public class IsValidOasisResponse extends AbstractSpecification<OasisRespondObject> {

    private final OasisResponseIF response;

    /**
     *
     * @param response
     */
    public IsValidOasisResponse(OasisResponseIF response) {
        this.response = response;
    }

    /**
     *
     * @param specsResp
     * @return
     */
    @Override
    public boolean isSatisfiedBy(OasisRespondObject specsResp) {
        if (response.getType().name().toUpperCase().startsWith(specsResp.getFieldId().trim().toUpperCase())) {
            int actualValue = -1;
            int specValue = -2;
            try {
                actualValue = Integer.parseInt(response.getValue());
                specValue = Integer.parseInt(specsResp.getResponse());
            } catch (NumberFormatException | NullPointerException nfe) {
                return false;
            }
            if (actualValue == specValue) {
                return true;
            }

        }
        return false;
    }

}
