/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification;

import com.mmm.cms.hh.pdgm.data.meta.enumer.PeriodTiming_EN;
import com.mmm.cms.hh.pdgm.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author US340646
 */
public class IsValidPeriodTiming extends AbstractSpecification<PeriodTiming_EN[]> {

	private final String value;
	
    /**
     *
     * @param value
     */
    public IsValidPeriodTiming(String value) {
		this.value = value;
	}
	
    /**
     *
     * @param periodTiming
     * @return
     */
    @Override
	public boolean isSatisfiedBy(PeriodTiming_EN[] periodTiming) {
            if(value == null) {
                return false;
            }
            for (PeriodTiming_EN val : PeriodTiming_EN.values()) {
                if(value.trim().equalsIgnoreCase("" + val.getId())) {
                    return true;
                }
            }
            return false;
	}

}
