/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification;

import com.mmm.cms.hh.pdgm.data.meta.enumer.ReferralSource_EN;
import com.mmm.cms.hh.pdgm.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author US340646
 */
public class IsValidReferralSource extends AbstractSpecification<ReferralSource_EN[]> {

	private final String value;
	
    /**
     *
     * @param value
     */
    public IsValidReferralSource(String value) {
		this.value = value;
	}
	
    /**
     *
     * @param referralSource
     * @return
     */
    @Override
	public boolean isSatisfiedBy(ReferralSource_EN[] referralSource) {
            if(value == null) {
                return false;
            }
            for (ReferralSource_EN val : ReferralSource_EN.values()) {
                if(value.trim().equalsIgnoreCase("" + val.getId())) {
                    return true;
                }
            }
            return false;
	}

}
