/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification.abstr;

/**
 *
 * @author US340646
 * @param <T>
 */
public abstract class AbstractSpecification<T> implements Specification<T> {

    /**
     *
     * @param t
     * @return
     */
    @Override
    public abstract boolean isSatisfiedBy(T t);

    /**
     *
     * @param s
     * @return
     */
    public AbstractSpecification<T> or(Specification<T> s) {
        return new OrSpecification<>(this, s);
    }

    /**
     *
     * @param s
     * @return
     */
    public AbstractSpecification<T> and(Specification<T> s) {
        return new AndSpecification<>(this, s);
    }

    /**
     *
     * @return
     */
    public AbstractSpecification<T> not() {
        return new NotSpecification<>(this);
    }

}
