/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.validation;

import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import java.util.List;

/**
 *
 * @author US340646
 */
public interface EditCollectionIF {

    /**
     *
     * @return
     */
    List<EditIF> getCriticalEdits();

    /**
     *
     * @param editId
     * @return
     */
    List<EditIF> getEditId(EditId_EN editId);

    /**
     *
     * @return
     */
    boolean hasCriticalEdits();

    /**
     *
     * @param editId
     * @return
     */
    boolean hasEditId(EditId_EN editId);

    /**
     *
     * @param edit
     */
    void addEdit(EditIF edit);

    /**
     *
     * @param editList
     */
    void addEdits(List<EditIF> editList);

    /**
     *
     * @return
     */
    List<EditIF> getEdits();
}
