/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.DxContainer;
import com.mmm.cms.hh.pdgm.data.exchange.DxContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ReturnCodeContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ValidityFlagContainerIF;
import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.Oasis_EN;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;
import com.mmm.cms.hh2.xml.data.claim.Claim;
import com.mmm.cms.hh2.xml.data.claim.ClinicalFields;
import com.mmm.cms.hh2.xml.data.claim.Diagnoses;
import com.mmm.cms.hh2.xml.data.claim.Dx;
import com.mmm.cms.hh2.xml.data.claim.FunctionalField;
import com.mmm.cms.hh2.xml.data.claim.FunctionalFields;
import com.mmm.cms.hh2.xml.data.claim.GrouperReturnCode;
import com.mmm.cms.hh2.xml.data.claim.HippsCode;
import com.mmm.cms.hh2.xml.data.claim.Input;
import com.mmm.cms.hh2.xml.data.claim.Options;
import com.mmm.cms.hh2.xml.data.claim.Output;
import com.mmm.cms.hh2.xml.data.claim.Principal;
import com.mmm.cms.hh2.xml.data.claim.Secondary;
import com.mmm.cms.hh2.xml.data.claim.Subfield;
import com.mmm.cms.hh2.xml.data.claim.ValidityFlag;
import com.mmm.cms.hh2.xml.data.claim.VersionUsed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author US340646
 */
public class ClaimObject extends Claim implements PositionAccessorIF, ClaimContainerIF {

    /**
     * Constructor
     */
    public ClaimObject() {
        // Create all inner objects upfront
        init();
    }

    private void init() {
        setOptions(new Options());
        setInput(new Input());
        getInput().setClinicalFields(new ClinicalFields());
        getInput().getClinicalFields().setDiagnoses(new Diagnoses());
        getInput().getClinicalFields().getDiagnoses().setPrincipal(new Principal());
        getInput().getClinicalFields().getDiagnoses().setSecondary(new Secondary());
        getInput().setFunctionalFields(new FunctionalFields());
        setOutput(new Output());
        getOutput().setVersionUsed(new VersionUsed());
        getOutput().setHippsCode(new HippsCode());
        getOutput().setValidityFlag(new ValidityFlag());
        getOutput().setGrouperReturnCode(new GrouperReturnCode());
    }

    @Override
    public String toString() {

        String nl = "\n";
        return "ClaimObject{" + nl
                + "ID='" + getId() + "'," + nl
                + "Description='" + (getDescription() == null ? "" : getDescription()) + "'," + nl
                + "From Date='" + getInput().getClinicalFields().getFromDate() + "'," + nl
                + "Period Timing='" + getInput().getClinicalFields().getPeriodTiming() + "'," + nl
                + "Referral Source='" + getInput().getClinicalFields().getReferralSource() + "'," + nl
                + formatDx(getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx(), "P", nl)
                + formatDx(getInput().getClinicalFields().getDiagnoses().getSecondary().getDx(), "S", nl)
                + formatOasis(getInput().getFunctionalFields().getFunctionalField(), nl)
                + "Version Used='" + formatVersion(getOutput().getVersionUsed()) + "'," + nl
                + "HIPPS Code='" + formatHippsCode(getOutput().getHippsCode()) + "'," + nl
                + "Validity Flag='" + getOutput().getValidityFlag().getValue() + "'," + nl
                + "Grouper Return Code='" + getOutput().getGrouperReturnCode().getValue() + "'," + nl
                + "ActionFlag='" + getOptions().getActionFlag() + "'," + nl
                + "}";
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        if (position == 0) {
            return getId();
        }
        if (position == 1) {
            return getInput().getClinicalFields().getFromDate();
        }
        if (position == 2) {
            return getInput().getClinicalFields().getPeriodTiming();
        }
        if (position == 3) {
            return getInput().getClinicalFields().getReferralSource();
        }

        if (position == 4) {
            Dx dx = getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
            String retDx = dx.getCode() + dx.getPoa();
            return retDx;
        }
        return null; // Exception???
    }

    @Override
    public boolean setByPosition(int position, String value) {

        // Claim ID
        if (position == 0) {
            setId(value);
        }

        // Claim From Date
        if (position == 1) {
            getInput().getClinicalFields().setFromDate(value);
        }

        // Claim Period Timing
        if (position == 2) {
            getInput().getClinicalFields().setPeriodTiming(value);
        }

        // Claim Referral Source
        if (position == 3) {
            getInput().getClinicalFields().setReferralSource(value);
        }

        if (position == 4) {
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));   // DX
            dx.setPoa(value.substring(value.length() - 1));       // POA
            dx.setOccurrence("0");
            getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
        }

        if (position > 4 && position <= 28) {
            List<Dx> dxList = getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));   // DX
            dx.setPoa(value.substring(value.length() - 1));       // POA
            dx.setOccurrence("" + (dxList.size() + 1));
            dxList.add(dx);
        }

        // M1033
        if (position > 33 && position <= 43) {
            FunctionalField ff = null;
            if (position == 34) {
                ff = new FunctionalField();
                String name = Oasis_EN.values()[0].name().substring(0, 5);
                ff.setFieldName(name);
                getInput().getFunctionalFields().getFunctionalField().add(ff);
            } else {
                ff = getInput().getFunctionalFields().getFunctionalField().get(0);
            }
            Subfield sf = new Subfield();
            sf.setName(Oasis_EN.values()[position - 34].name());
            sf.setValue(value);
            ff.getSubfield().add(sf);
        }

        // M18XX fields
        if (position > 43 && position < 51) {
            FunctionalField ff = new FunctionalField();
            Subfield sf = new Subfield();
            String name = Oasis_EN.values()[position - (44 - 10)].name();
            ff.setFieldName(name.substring(0, 5));
            sf.setName(name);
            sf.setValue(value);
            ff.getSubfield().add(sf);
            getInput().getFunctionalFields().getFunctionalField().add(ff);
        }

        // position = 51 is filler
        // Options
        // Action Flag
        if (position == 52) {
            getOptions().setActionFlag(value);
        }
        // Output
        if (position == 53) {
            VersionUsed vu = getOutput().getVersionUsed();
            if (value.contains(".")) {
                vu.setVersion(value.substring(0, 2));
                vu.setRelease(value.substring(3, 4));
                vu.setYear(value.substring(5));
            } else {
                vu.setVersion(value);
                vu.setRelease("");
                vu.setYear("");
            }
        }
        if (position == 54) {
            HippsCode hc = getOutput().getHippsCode();
            hc.setEpisodeTiming(value.substring(0, 1));
            hc.setClinicalGroup(value.substring(1, 2));
            hc.setFunctionalLevel(value.substring(2, 3));
            hc.setComorbidityPresent(value.substring(3, 4));
            hc.setFiller(value.substring(4, 5));

        }
        if (position == 55) {
            ValidityFlag vf = getOutput().getValidityFlag();
            vf.setValue(value);
        }
        if (position == 56) {
            GrouperReturnCode grc = getOutput().getGrouperReturnCode();
            grc.setValue(value);
        }

        return false; // Exception???
    }

    private String formatDx(Dx dx, String pref, String del) {
        if(dx.getCode().trim().isEmpty()) {
            return null;
        }
        return pref + "DX='{'" + dx.getCode() + "','" + dx.getPoa() + "','" + dx.getOccurrence() + "'}" + del;
    }

    private String formatDx(List<Dx> dxList, String pref, String del) {
        // get rid of empty SDXs
        StringBuilder ret = new StringBuilder();
        dxList.stream().map((dx) -> formatDx(dx, pref, del)).filter((retStr) -> (retStr != null)).forEachOrdered((retStr) -> {
            ret.append(retStr);
        });
        return ret.toString();
    }

    private String formatOasis(List<FunctionalField> ffList, String del) {
        String ret = "";
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            ret = sfList.stream().map((sf) -> "OASIS Field={" + sf.getName() + "='" + sf.getValue() + "'}" + del).reduce(ret, String::concat);
        }
        return ret;
    }

    private String formatVersion(VersionUsed vu) {
        String ret = "";
        ret = vu.getVersion() + "." + vu.getRelease() + "." + vu.getYear();
        return ret;
    }

    private String formatHippsCode(HippsCode hc) {
        String ret = "";
        ret = hc.getEpisodeTiming() + hc.getClinicalGroup() + hc.getFunctionalLevel() + hc.getComorbidityPresent() + hc.getFiller();
        return ret;
    }

    /**
     *
     * @return
     */
    public String tempGetOutput() {
        return formatVersion(getOutput().getVersionUsed())
                + formatHippsCode(getOutput().getHippsCode())
                + getOutput().getValidityFlag().getValue()
                + getOutput().getGrouperReturnCode().getValue();
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 56;
    }

    private boolean loadDescription;

    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

    @Override
    public String getHippsCode() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     *
     * @return
     */
    @Override
    public String getReturnCodeValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     *
     * @return
     */
    @Override
    public String getReturnCodeDescription() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     *
     * @return
     */
    @Override
    public String getValidityFlagValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     *
     * @return
     */
    @Override
    public String getValidityFlagDescription() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getVersionUsed() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setAmbulation(String ambulation) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setBathing(String bathing) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getClaimId() {
        return getId();
    }

    @Override
    public void setClaimId(String claimId) {
        setId(claimId);
    }

    @Override
    public void setDressLower(String dressLower) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setDressUpper(String dressUpper) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setFromDate(String fromDate) {
        getInput().getClinicalFields().setFromDate(fromDate);
    }

    @Override
    public void setGrooming(String grooming) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskCompliance(String hospRiskCompliance) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskFiveMoreMeds(String hospRiskFiveMoreMeds) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskHistoryFalls(String hospRiskHistoryFalls) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskMentalBehavDecl(String hospRiskMentalBehavDecl) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskMultiEdVisit(String hospRiskMultiEdVisit) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskMultiHospital(String hospRiskMultiHospital) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskNoneAbove(String hospRiskNoneAbove) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskOtherRisk(String hospRiskOtherRisk) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskExhaustion(String hospRiskExhaustion) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHospRiskWeightLoss(String hospRiskWeightLoss) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setPdx(String pdx, String poa) {
        Dx dx = new Dx();
        dx.setCode(pdx);   // DX
        dx.setPoa(poa);   // POA
        dx.setOccurrence("0");
        getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    /**
     *
     * @param sdx
     * @param poa
     */
    @Override
    public void addSdx(String sdx, String poa) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setPeriodTiming(String periodTiming) {
        getInput().getClinicalFields().setPeriodTiming(periodTiming);
    }

    @Override
    public void setReferralSource(String referralSource) {
        getInput().getClinicalFields().setReferralSource(referralSource);
    }

    @Override
    public void setToileting(String toileting) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setTransferring(String transferring) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getAmbulation() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getBathing() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getDressLower() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getDressUpper() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getFromDate() {
        return getInput().getClinicalFields().getFromDate();
    }

    @Override
    public String getGrooming() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskCompliance() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskFiveMoreMeds() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskHistoryFalls() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskMentalBehavDecl() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskMultiEdVisit() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskMultiHospital() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskNoneAbove() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskOtherRisk() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskExhaustion() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getHospRiskWeightLoss() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public DxContainerIF getPdx() { // refactoring (close coupling) later?
        Dx dx = getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
        DxContainerIF pdx = new DxContainer(dx.getCode(), dx.getPoa());
        return pdx;
    }

    @Override
    public String getPeriodTiming() {
        return getInput().getClinicalFields().getPeriodTiming();
    }

    @Override
    public String getReferralSource() {
        return getInput().getClinicalFields().getReferralSource();
    }

    @Override
    public ReturnCodeContainerIF getReturnCode() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public List<DxContainerIF> getSdxList() {
        List<DxContainerIF> retList = null;
        List<Dx> dxList = getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
        for (Dx dx : dxList) {
            DxContainerIF diag = new DxContainer(dx.getCode(), dx.getPoa());
            if (retList == null) {
                retList = new ArrayList<>();
            }
            retList.add(diag);
        }
        return retList;
    }

    @Override
    public String getToileting() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getTransferring() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public ValidityFlagContainerIF getValidityFlag() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setHippsCode(String HippsCode) {
        setByPosition(54, HippsCode);
    }

    @Override
    public void setPdx(DxContainerIF pdx) {
        Dx dx = new Dx();
        dx.setCode(pdx.getDx());   // DX
        dx.setPoa(pdx.getPoa());   // POA
        dx.setOccurrence("0");
        getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    @Override
    public void setReturnCode(ReturnCodeContainerIF returnCode) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setSdxList(List<DxContainerIF> sdxList) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setValidityFlag(ValidityFlagContainerIF validityFlag) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setVersionUsed(String versionUsed) {
        setByPosition(53, versionUsed);
    }

    /**
     *
     * @return
     */
    @Override
    public Map<String, String> getFunctionalFields() {
        Map<String, String> retMap = new HashMap<>();
        List<FunctionalField> ffList = getInput().getFunctionalFields().getFunctionalField();
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            for (Subfield sf : sfList) {
                retMap.put(sf.getName(), sf.getValue());
            }
        }
        return retMap;
    }

    @Override
    public EditCollectionIF getEdits() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setEdits(EditCollectionIF edits) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

}
