/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.ComorbidityInteraction;

/**
 *
 * @author US340646
 */
public class ComorbidityInteractionObject extends ComorbidityInteraction implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Comorbidity Interaction ID:'" + getId() +
                "', Comorbidity Group 1:'" + getGroup1() +
                "', Comorbidity Group 2:'" + getGroup2() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getGroup1();
            case 2:
                return getGroup2();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setGroup1(value);
                return true;
            case 2:
                setGroup2(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 3;
    }


    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
