/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.Diagnosis;

/**
 *
 * @author US340646
 */
public class DiagnosisObject extends Diagnosis implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Diagnosis Value:'" + getValue() +
                "', Diagnosis Description:'" + getDescription() +
                "', Clinical Group:'" + getClinicalGroup() +
                "', SubChapter:'" + getSubChapter()+
                "', Comorbidity Group:'" + getComorbidityGroup() +
                "', Manifestation Flag:'" + getManifestationFlag() +
                "', Primary Awarding Flag:'" + getPrimaryAwardingFlag() +
                "', ECoI Flag:'" + getEcoiFlag() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getValue();
            case 1:
                return getDescription();
            case 2:
                return getClinicalGroup();
            case 3:
                return getSubChapter();
            case 4:
                return getComorbidityGroup();
            case 5:
                return getManifestationFlag();
            case 6:
                return getPrimaryAwardingFlag();
            case 7:
                return getEcoiFlag();
            default:
                return null; // Exception???
        }
    }

    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setValue(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            case 2:
                setClinicalGroup(value);
                return true;
            case 3:
                setSubChapter(value);
                return true;
            case 4:
                setComorbidityGroup(value);
                return true;
            case 5:
                setManifestationFlag(value);
                return true;
            case 6:
                setPrimaryAwardingFlag(value);
                return true;
            case 7:
                setEcoiFlag(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 8;
    }


    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
