/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.grouper.version.GrouperVersion;

/**
 *
 * @author US340646
 */
public class GrouperVersionObject extends GrouperVersion implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Version ID:'" + getId() +
                "', Description:'" + getDescription() +
                "', Start Date:'" + getStartDate() +
                "', End Date:'" + getEndDate() +
                "', Active Flag:'" + getActiveFlag() +
                "', Default Flag:'" + getDefaultFlag() +
                "', Java Class:'" + getJavaClass() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getDescription();
            case 2:
                return getStartDate();
            case 3:
                return getEndDate();
            case 4:
                return getActiveFlag();
            case 5:
                return getDefaultFlag();
            case 6:
                return getJavaClass();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            case 2:
                setStartDate(value);
                return true;
            case 3:
                setEndDate(value);
                return true;
            case 4:
                setActiveFlag(value);
                return true;
            case 5:
                setDefaultFlag(value);
                return true;
            case 6:
                setJavaClass(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 7;
    }

    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
