/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;
import gov.cms.hh.common.abstr.NameableIF;
import gov.cms.hh.common.abstr.ValuableIF;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import java.io.Serializable;
import java.text.ParseException;

public class ClinicalGroup
implements IdentifiableIF,
ValuableIF,
NameableIF,
DescribableIF,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String value;
    private String name;
    private String description;
    private int lowPoints;
    private int highPoints;

    public String toString() {
        return "ClinicalGroup{id=" + this.id + ", value=" + this.value + ", name=" + this.name + ", description=" + this.description + ", lowPoints=" + this.lowPoints + ", highPoints=" + this.highPoints + '}';
    }

    public ClinicalGroup() {
    }

    public ClinicalGroup(int id, String value, String name, String description, int lowPoints, int highPoints) {
        this.id = id;
        this.value = value;
        this.name = name;
        this.description = description;
        this.lowPoints = lowPoints;
        this.highPoints = highPoints;
    }

    public ClinicalGroup(int id, ClinicalGroupObject cgo) throws ParseException {
        this(id, cgo.getId(), cgo.getName(), cgo.getDescription(), Integer.parseInt(cgo.getLowPoints()), Integer.parseInt(cgo.getHighPoints()));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public int getLowPoints() {
        return this.lowPoints;
    }

    public void setLowPoints(int lowPoints) {
        this.lowPoints = lowPoints;
    }

    public int getHighPoints() {
        return this.highPoints;
    }

    public void setHighPoints(int highPoints) {
        this.highPoints = highPoints;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }
}

