/*
 * Decompiled with CFR 0.152.
 */
package com.modal;

import com.modal.DiagnosisCode;
import com.modal.display.DxType;
import com.modal.display.EarlyLateComboBox;
import com.modal.display.ReferralSourceComboBox;
import com.utilities.Log;
import com.utilities.formattor.ReportHeaders;
import gov.cms.hh.application.HHGrouper;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import javafx.collections.ObservableList;

public class ClaimInput
extends ReportHeaders {
    private ClaimContainerIF claimContainer;
    private ObservableList<DiagnosisCode> dxData;
    private String claimID;
    private String fromDate;
    private String periodTiming;
    private String referralSource;
    private String grooming;
    private String dressUpper;
    private String dressLower;
    private String bathing;
    private String toileting;
    private String transferring;
    private String ambulation;
    private boolean isFalls;
    private boolean isWeight;
    private boolean isMultHos;
    private boolean isMultEmg;
    private boolean isMental;
    private boolean isCompliance;
    private boolean isMedications;
    private boolean isExhaustion;
    private boolean isOther;
    private boolean isNone;

    public ClaimInput(String claimID, String fromDate, String periodTiming, String referralSource, ObservableList<DiagnosisCode> dxData, boolean isFalls, boolean isWeight, boolean isMultHos, boolean isMultEmg, boolean isMental, boolean isCompliance, boolean isMedications, boolean isExhaustion, boolean isOther, boolean isNone, String grooming, String dressUpper, String dressLower, String bathing, String toileting, String transferring, String ambulation) {
        this.claimID = claimID;
        this.fromDate = fromDate;
        this.periodTiming = periodTiming;
        this.referralSource = referralSource;
        this.dxData = dxData;
        this.isFalls = isFalls;
        this.isWeight = isWeight;
        this.isMultHos = isMultHos;
        this.isMultEmg = isMultEmg;
        this.isMental = isMental;
        this.isCompliance = isCompliance;
        this.isMedications = isMedications;
        this.isExhaustion = isExhaustion;
        this.isOther = isOther;
        this.isNone = isNone;
        this.grooming = grooming;
        this.dressUpper = dressUpper;
        this.dressLower = dressLower;
        this.bathing = bathing;
        this.toileting = toileting;
        this.transferring = transferring;
        this.ambulation = ambulation;
        try {
            this.claimContainer = HHGrouper.getEmptyClaim(this.fromDate);
            this.claimContainer.setClaimId(claimID);
            this.claimContainer.setFromDate(fromDate);
            this.claimContainer.setPeriodTiming(EarlyLateComboBox.getGrouperInput(periodTiming));
            this.claimContainer.setReferralSource(ReferralSourceComboBox.getGrouperInput(referralSource));
            for (DiagnosisCode tableDiagnoses : dxData) {
                String poa = tableDiagnoses.getPoa();
                if (poa.equals("")) {
                    poa = " ";
                }
                String dx = tableDiagnoses.getDiagnosis();
                if (tableDiagnoses.getDxType().equalsIgnoreCase(DxType.PRINCIPAL.toString())) {
                    this.claimContainer.setPdx(dx, poa);
                    continue;
                }
                this.claimContainer.addSdx(dx, poa);
            }
            this.claimContainer.setHospRiskHistoryFalls(this.isYes(isFalls));
            this.claimContainer.setHospRiskWeightLoss(this.isYes(isWeight));
            this.claimContainer.setHospRiskMultiHospital(this.isYes(isMultHos));
            this.claimContainer.setHospRiskMultiEdVisit(this.isYes(isMultEmg));
            this.claimContainer.setHospRiskMentalBehavDecl(this.isYes(isMental));
            this.claimContainer.setHospRiskCompliance(this.isYes(isCompliance));
            this.claimContainer.setHospRiskFiveMoreMeds(this.isYes(isMedications));
            this.claimContainer.setHospRiskExhaustion(this.isYes(isExhaustion));
            this.claimContainer.setHospRiskOtherRisk(this.isYes(isOther));
            this.claimContainer.setHospRiskNoneAbove(this.isYes(isNone));
            this.claimContainer.setGrooming(grooming.substring(0, 2));
            this.claimContainer.setDressUpper(dressUpper.substring(0, 2));
            this.claimContainer.setDressLower(dressLower.substring(0, 2));
            this.claimContainer.setBathing(bathing.substring(0, 2));
            this.claimContainer.setToileting(toileting.substring(0, 2));
            this.claimContainer.setTransferring(transferring.substring(0, 2));
            this.claimContainer.setAmbulation(ambulation.substring(0, 2));
        }
        catch (Exception e) {
            Log.l(e.getMessage(), Log.ERROR_LEVEL.ERROR);
        }
    }

    public String toString() {
        StringBuilder i = new StringBuilder();
        i.append("\n************** Claim Input ***********************\n");
        ReportHeaders.valueWithLabel("Claim ID", this.claimID, i);
        ReportHeaders.valueWithLabel("From Date", this.fromDate, i);
        ReportHeaders.valueWithLabel("Period Timing", this.periodTiming, i);
        ReportHeaders.valueWithLabel("Referral Source", this.referralSource, i);
        for (DiagnosisCode d : this.dxData) {
            i.append(d.toString()).append("\n");
        }
        ReportHeaders.valueWithLabel("M1033 Falls", this.isYes(this.isFalls), i);
        ReportHeaders.valueWithLabel("M1033 Weight", this.isYes(this.isWeight), i);
        ReportHeaders.valueWithLabel("M1033 Mult Hospital", this.isYes(this.isMultHos), i);
        ReportHeaders.valueWithLabel("M1033 Mult Emergency", this.isYes(this.isMultEmg), i);
        ReportHeaders.valueWithLabel("M1033 Mental ", this.isYes(this.isMental), i);
        ReportHeaders.valueWithLabel("M1033 Compliance", this.isYes(this.isCompliance), i);
        ReportHeaders.valueWithLabel("M1033 Medications", this.isYes(this.isMedications), i);
        ReportHeaders.valueWithLabel("M1033 Exhaustion", this.isYes(this.isExhaustion), i);
        ReportHeaders.valueWithLabel("M1033 Other", this.isYes(this.isOther), i);
        ReportHeaders.valueWithLabel("M1033 None", this.isYes(this.isNone), i);
        ReportHeaders.valueWithLabel("Grooming", this.grooming, i);
        ReportHeaders.valueWithLabel("Dress Upper", this.dressUpper, i);
        ReportHeaders.valueWithLabel("Dress Lower", this.dressLower, i);
        ReportHeaders.valueWithLabel("Bathing", this.bathing, i);
        ReportHeaders.valueWithLabel("Toileting", this.toileting, i);
        ReportHeaders.valueWithLabel("Transferring", this.transferring, i);
        ReportHeaders.valueWithLabel("Ambulation", this.ambulation, i);
        i.append("**************************************************\n");
        return i.toString();
    }

    public ClaimContainerIF getClaimContainer() {
        return this.claimContainer;
    }

    private String isYes(boolean s) {
        return s ? "1" : "0";
    }
}

