/*
 * Decompiled with CFR 0.152.
 */
package com.modal.referenceTable;

import com.modal.referenceTable.RTColumn;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public abstract class ReferenceTable {
    ArrayList<RTColumn> columns = new ArrayList();
    TableView tableView = new TableView();
    String[] columnProperties;
    ObservableList formattedData = FXCollections.observableArrayList();

    <T> void setTable(TableView table, ArrayList<RTColumn> columns) {
        for (RTColumn column : columns) {
            Label label = new Label(column.getHeaderColumn());
            TableColumn c = new TableColumn("");
            TextField headerTextField = new TextField();
            VBox headerGraphic = new VBox();
            c.setCellValueFactory((Callback)new PropertyValueFactory(column.getPropertyName()));
            c.setSortable(false);
            c.setResizable(true);
            headerTextField.setPrefWidth(75.0);
            headerTextField.setText(column.getFilterValue());
            headerTextField.setId(column.getPropertyName());
            headerTextField.setFocusTraversable(true);
            label.setPrefWidth((double)(column.getHeaderColumn().length() * 10));
            headerGraphic.setAlignment(Pos.CENTER);
            headerGraphic.getChildren().addAll((Object[])new Node[]{label, headerTextField});
            headerGraphic.setPrefWidth(label.getPrefWidth() > headerTextField.getPrefWidth() ? label.getPrefWidth() : headerTextField.getPrefWidth());
            c.setGraphic((Node)headerGraphic);
            c.setPrefWidth(c.getWidth());
            table.getColumns().add((Object)c);
        }
        table.setItems(this.formattedData);
    }

    void createColumns(List<String> headers, String[] filterValues) {
        this.columns.clear();
        for (int i = 0; i < this.columnProperties.length; ++i) {
            if (filterValues == null) {
                this.columns.add(new RTColumn(headers.get(i), this.columnProperties[i], ""));
                continue;
            }
            this.columns.add(new RTColumn(headers.get(i), this.columnProperties[i], filterValues.length == this.columnProperties.length ? filterValues[i] : ""));
        }
    }

    public TableView getTable() {
        return this.tableView;
    }
}

