/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.interf.PositionAccessorIF;
import gov.cms.hh.xml.layout.rot.ComorbidityGroup;

/**
 *
 * @author CMS
 */
public class ComorbidityGroupObject extends ComorbidityGroup implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Comorbidity Group Name:'" + getName() +
                "', Comorbidity Group Description:'" + getDescription() +
                "', Low Comorbidity Flag:'" + getLowComorbidityFlag() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getName();
            case 1:
                return getDescription();
            case 2:
                return getLowComorbidityFlag();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setName(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            case 2:
                setLowComorbidityFlag(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 3;
    }

    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

}
