/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.loader;

import gov.cms.hh.data.interf.LineParserIF;
import gov.cms.hh.grouper.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author CMS
 */
public class LineParser implements LineParserIF {

    private static final Logger LOG = Logger.getLogger(LineParser.class.getName());
    
    // Char Separated Values parser 

    /**
     *
     * @param delimiter
     */
    public LineParser(String delimiter) {
        this.parseTo = (String line) -> {
            List<String> retList = new ArrayList<>();
            StringTokenizer tokenizer = new StringTokenizer(line, delimiter);
            while (tokenizer.hasMoreTokens()) {
                retList.add(tokenizer.nextToken());
            }
            return retList;
        };
    }

    // Fixed Format Parser with variable field length

    /**
     *
     * @param fieldSizeList
     */
    public LineParser(List<Integer> fieldSizeList) {
        int layoutLen = Utility.sum(fieldSizeList);
        this.parseTo = (String line) -> {
            List<String> retList = new ArrayList();
            if (layoutLen <= line.length()) {
                int start = 0;
                for (int i = 0; i < fieldSizeList.size(); i++) {
                    retList.add(line.substring(start, start + fieldSizeList.get(i)));
                    start += fieldSizeList.get(i);
                }
            } else {
                LOG.log(Level.SEVERE, "Input Record Length error = {0} chars", layoutLen);
            }
            return retList;
        };
    }

    // Default (Tab Separated) Parser

    /**
     * Constructor with default TAB separator
     */
    public LineParser() {
        this("\t");
    }

    /**
     *
     * @param line
     * @return
     */
    @Override
    public List<String> parseLine(String line) {
        return Stream.of(line).map(parseTo).collect(Collectors.toList()).get(0);
    }

    private final Function<String, List<String>> parseTo;

}
