/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.claim.OasisResponseIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import gov.cms.hh.reference.objects.OasisRespondObject;

/**
 *
 * @author CMS
 */
public class IsValidOasisResponse extends AbstractSpecification<OasisRespondObject> {

    private final OasisResponseIF response;

    /**
     *
     * @param response
     */
    public IsValidOasisResponse(OasisResponseIF response) {
        this.response = response;
    }

    /**
     *
     * @param specsResp
     * @return
     */
    @Override
    public boolean isSatisfiedBy(OasisRespondObject specsResp) {
        if (response.getType().name().toUpperCase().startsWith(specsResp.getFieldId().trim().toUpperCase())) {
            int actualValue = -1;
            int specValue = -2;
            try {
                actualValue = Integer.parseInt(response.getValue());
                specValue = Integer.parseInt(specsResp.getResponse());
            } catch (NumberFormatException | NullPointerException nfe) {
                return false;
            }
            if (actualValue == specValue) {
                return true;
            }

        }
        return false;
    }

}
