/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.data.loader;

import gov.cms.hh.data.interf.DataLoaderIF;
import gov.cms.hh.data.interf.LineParserIF;
import gov.cms.hh.data.interf.PositionAccessorIF;
import gov.cms.hh.data.interf.RecordLayoutIF;
import gov.cms.hh.data.loader.LineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataLoader<T>
implements DataLoaderIF {
    private static final Logger LOG = Logger.getLogger(DataLoader.class.getName());
    private final Function<String, T> mapTo = line -> {
        List<String> tokens = lineParser.parseLine((String)line);
        try {
            Object t = clazz.newInstance();
            PositionAccessorIF data = (PositionAccessorIF)t;
            data.setLoadDescription(loadDescriptions);
            for (int i = 0; i < tokens.size(); ++i) {
                data.setByPosition(i, tokens.get(i));
            }
            return t;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(DataLoader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    };

    public DataLoader(Class<T> clazz) {
        this(clazz, new LineParser(), false);
    }

    public DataLoader(Class<T> clazz, boolean loadDescriptions) {
        this(clazz, new LineParser(), loadDescriptions);
    }

    public DataLoader(Class<T> clazz, RecordLayoutIF recordLayout) {
        this(clazz, recordLayout, false);
    }

    public DataLoader(Class<T> clazz, RecordLayoutIF recordLayout, boolean loadDescriptions) {
        this(clazz, new LineParser(recordLayout.getLayout()), loadDescriptions);
    }

    public DataLoader(Class<T> clazz, LineParserIF lineParser) {
        this(clazz, lineParser, false);
    }

    public DataLoader(Class<T> clazz, LineParserIF lineParser, boolean loadDescriptions) {
    }

    public List<T> loadFile(InputStream inputFile, boolean withHeaders) {
        List<Object> inputList = new ArrayList();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputFile, "UTF8"));
            inputList = withHeaders ? br.lines().map(this.mapTo).collect(Collectors.toList()) : br.lines().skip(1L).map(this.mapTo).collect(Collectors.toList());
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return inputList;
    }

    @Override
    public List<T> loadFile(String inputFile, boolean withHeaders) {
        File inputF = new File(inputFile);
        FileInputStream inputFS = null;
        try {
            inputFS = new FileInputStream(inputF);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DataLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.loadFile(inputFS, withHeaders);
    }

    @Override
    public List<T> loadFile(String fileName) {
        return this.loadFile(fileName, false);
    }

    public List<T> loadFile(InputStream inputFile) {
        return this.loadFile(inputFile, false);
    }

    @Override
    public T load(String s) {
        return Stream.of(s).map(this.mapTo).collect(Collectors.toList()).get(0);
    }
}

