/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.App;
import com.TextFieldListener;
import com.modal.ClaimInput;
import com.modal.DiagnosisCode;
import com.modal.Grouper;
import com.modal.Popup;
import com.modal.display.DxType;
import com.utilities.Log;
import com.utilities.component.ComponentManager;
import com.utilities.formattor.StringFormattor;
import com.utilities.nodes.ComboBoxManager;
import com.utilities.nodes.LabelManager;
import com.utilities.nodes.NodeUtils;
import com.utilities.nodes.TabManager;
import com.utilities.nodes.TableManager;
import com.utilities.nodes.TextFieldManager;
import gov.cms.hh.application.HHGrouper;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Controller
implements Initializable {
    private static final String HH_ACCESSIBILITY_BASE_DATE_PICKER_MESSAGE = " Use the date picker or use the MM/DD/YYYY format and press Enter.";
    private static ObservableList<DiagnosisCode> dxData = FXCollections.observableArrayList();
    @FXML
    private Button addPDXButton;
    @FXML
    private Button addSDXButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button exportAllButton;
    @FXML
    private Button exportTableButton;
    @FXML
    private Button exportViewButton;
    @FXML
    private Button removeDXButton;
    @FXML
    private Button saveDetailedReportButton;
    @FXML
    private Button saveOutputReportButton;
    @FXML
    private CheckBox compliance;
    @FXML
    private CheckBox exhaustion;
    @FXML
    private CheckBox falls;
    @FXML
    private CheckBox medications;
    @FXML
    private CheckBox mentalBehavior;
    @FXML
    private CheckBox multipleEmergency;
    @FXML
    private CheckBox multipleHospitalizations;
    @FXML
    private CheckBox none;
    @FXML
    private CheckBox otherRisks;
    @FXML
    private CheckBox weightLoss;
    @FXML
    private ComboBox<String> ambulation;
    @FXML
    private ComboBox<String> bathing;
    @FXML
    private ComboBox<String> dressLower;
    @FXML
    private ComboBox<String> dressUpper;
    @FXML
    private ComboBox<String> grooming;
    @FXML
    private ComboBox<String> grouperTable;
    @FXML
    private ComboBox<String> grouperVersion;
    @FXML
    private ComboBox<String> periodTimingEL;
    @FXML
    private ComboBox<String> referralSource;
    @FXML
    private ComboBox<String> toileting;
    @FXML
    private ComboBox<String> transferring;
    @FXML
    private DatePicker fromDatePicker;
    @FXML
    private Pane baseGridPane;
    @FXML
    private Label descriptionLabel;
    @FXML
    private Label startDateLabel;
    @FXML
    private MenuItem close;
    @FXML
    private MenuItem about;
    @FXML
    private Pagination referenceTablePagination;
    @FXML
    private Tab componentOutputTab;
    @FXML
    private Tab claimInputTab;
    @FXML
    private Tab detailedReportTab;
    @FXML
    private Tab referenceTableTab;
    @FXML
    private TableView referenceTableView;
    @FXML
    private TableView<DiagnosisCode> pdxTableView;
    @FXML
    private TabPane baseTabPane;
    @FXML
    private TextArea componentOutput;
    @FXML
    private TextArea detailedOutput;
    @FXML
    private TextField claimID;
    @FXML
    private TextField dxCode;
    @FXML
    private TextField dxCodeDescription;
    @FXML
    private TextField dxPoa;
    private boolean isInsertSDX;
    private boolean isRemoveDX;
    private double MAX_ROWS_IN_PAGE = 22.0;
    private KeyCode lastKeyPress;
    private String fromDate = "19700101";
    private TextField selectedTextField;
    private static String previousRFSelection;
    private boolean isSaveAccess;

    public Controller() {
        HHGrouper.setLoadDescription(true);
    }

    @FXML
    private void addPdxAction(ActionEvent actionEvent) {
        if (!this.dxCode.getText().trim().equals("")) {
            Log.logTextField(this.dxCode);
            Log.logTextField(this.dxCodeDescription);
            DiagnosisCode d = new DiagnosisCode(this.convertDXPeriods(this.dxCode.getText()), "", DxType.PRINCIPAL, this.dxCodeDescription.getText(), 0);
            if (dxData.size() > 0) {
                dxData.set(0, (Object)d);
            } else {
                dxData.add(0, (Object)d);
            }
            TextFieldManager.clearTextFields(new TextField[]{this.dxCode, this.dxCodeDescription});
            TabManager.disableTab(this.detailedReportTab, false);
            TabManager.disableTab(this.componentOutputTab, false);
        }
    }

    @FXML
    private void addSdxAction(ActionEvent actionEvent) {
        if (!this.dxCode.getText().trim().equals("")) {
            int insertCodeIndex = -1;
            int MAX_PDX_CODES = 1;
            int MAX_SDX_CODES = 24;
            Log.logTextField(this.dxCode);
            Log.logTextField(this.dxCodeDescription);
            if (!this.isInsertSDX) {
                for (DiagnosisCode d : dxData) {
                    if (d.getId() < insertCodeIndex) continue;
                    insertCodeIndex = d.getId();
                }
                if (insertCodeIndex == -1) {
                    insertCodeIndex = 0;
                    dxData.add(insertCodeIndex, (Object)new DiagnosisCode(insertCodeIndex));
                }
                ++insertCodeIndex;
            } else {
                insertCodeIndex = ((DiagnosisCode)this.pdxTableView.getSelectionModel().getSelectedItem()).getId();
                for (DiagnosisCode diagnosisCode : dxData) {
                    if (diagnosisCode.getId() < ((DiagnosisCode)this.pdxTableView.getSelectionModel().getSelectedItem()).getId()) continue;
                    diagnosisCode.setId(diagnosisCode.getId() + 1);
                }
                TableManager.clearSelection(this.pdxTableView);
            }
            if (insertCodeIndex < MAX_PDX_CODES + MAX_SDX_CODES && dxData.size() < MAX_PDX_CODES + MAX_SDX_CODES) {
                Log.logTextField(this.dxCode);
                Log.logTextField(this.dxCodeDescription);
                dxData.add(insertCodeIndex, (Object)new DiagnosisCode(this.convertDXPeriods(this.dxCode.getText()), "", DxType.SECONDARY, this.dxCodeDescription.getText(), insertCodeIndex));
            } else {
                new Popup(Alert.AlertType.INFORMATION, "Information", "Maximum Secondary Diagnosis Codes Reached.", "The maximum number of secondary diagnosis codes is " + MAX_SDX_CODES).showAndWait();
            }
            TextFieldManager.clearTextFields(new TextField[]{this.dxCode, this.dxCodeDescription});
        }
    }

    @FXML
    private void remDxAction(ActionEvent actionEvent) {
        DiagnosisCode d = (DiagnosisCode)this.pdxTableView.getSelectionModel().getSelectedItem();
        if (d != null) {
            Log.logTextField(this.dxCode);
            Log.logTextField(this.dxCodeDescription);
            dxData.remove((Object)d);
            if (d.getId() == 0 && dxData.size() > 0) {
                dxData.add(0, (Object)new DiagnosisCode(0));
                TabManager.disableTab(this.detailedReportTab, true);
                TabManager.disableTab(this.componentOutputTab, true);
            }
            if (this.pdxTableView.getItems().size() == 1 && ((DiagnosisCode)dxData.get(0)).getDxType().equals("") || this.pdxTableView.getItems().size() == 0) {
                TabManager.disableTab(this.detailedReportTab, true);
                TabManager.disableTab(this.componentOutputTab, true);
                dxData.clear();
            }
            if (dxData.size() > 1) {
                for (DiagnosisCode diagnosisCode : dxData) {
                    if (diagnosisCode.getId() <= d.getId() || d.getId() <= 0) continue;
                    diagnosisCode.setId(diagnosisCode.getId() - 1);
                }
            }
            this.pdxTableView.refresh();
            this.isRemoveDX = true;
            this.removeDXButton.setDisable(true);
            this.removeDXButton.setText("Remove DX");
            TableManager.clearSelection(this.pdxTableView);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        TableManager.initDxTable(this.pdxTableView, dxData);
        ComboBoxManager.initComboBoxes(NodeUtils.getAllComboBoxes((Parent)this.baseGridPane));
        TableManager.setPagenation(this.referenceTablePagination, 0, this.MAX_ROWS_IN_PAGE);
        LabelManager.clearLabel(this.startDateLabel);
        LabelManager.clearLabel(this.descriptionLabel);
        this.fromDatePicker.focusedProperty().addListener((arg0, oldPropertyValue, newPropertyValue) -> {
            StringBuilder sb = new StringBuilder("From Date ");
            if (this.fromDatePicker.getValue() != null && this.fromDatePicker.getEditor().getText() != null) {
                sb.append(StringFormattor.convertToDomainDate(((LocalDate)this.fromDatePicker.getValue()).toString(), "yyyy-MM-dd", "MM/dd/YYYY"));
            }
            sb.append(HH_ACCESSIBILITY_BASE_DATE_PICKER_MESSAGE);
            this.fromDatePicker.setAccessibleText(sb.toString());
        });
        this.compliance.setAccessibleText(this.compliance.getTooltip().getText());
        this.exhaustion.setAccessibleText(this.exhaustion.getTooltip().getText());
        this.falls.setAccessibleText(this.falls.getTooltip().getText());
        this.medications.setAccessibleText(this.medications.getTooltip().getText());
        this.mentalBehavior.setAccessibleText(this.mentalBehavior.getTooltip().getText());
        this.multipleEmergency.setAccessibleText(this.multipleEmergency.getTooltip().getText());
        this.multipleHospitalizations.setAccessibleText(this.multipleHospitalizations.getTooltip().getText());
        this.none.setAccessibleText(this.none.getTooltip().getText());
        this.otherRisks.setAccessibleText(this.otherRisks.getTooltip().getText());
        this.weightLoss.setAccessibleText(this.weightLoss.getTooltip().getText());
        this.fromDatePicker.setAccessibleText(this.fromDatePicker.getTooltip().getText());
        this.clearButton.setAccessibleText(this.clearButton.getTooltip().getText());
        this.referralSource.setAccessibleText(this.referralSource.getTooltip().getText());
        this.periodTimingEL.setAccessibleText(this.periodTimingEL.getTooltip().getText());
        this.saveOutputReportButton.setAccessibleText(this.saveOutputReportButton.getTooltip().getText());
        this.pdxTableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null && newSelection.getId() > 0 && !this.isRemoveDX) {
                this.addSDXButton.setText("Insert SDX");
                this.addPDXButton.setText("Add PDX");
                this.removeDXButton.setDisable(false);
                this.isInsertSDX = true;
            } else if (newSelection != null && newSelection.getId() == 0 && !this.isRemoveDX) {
                this.addSDXButton.setText("Add SDX");
                this.removeDXButton.setDisable(false);
            } else {
                this.addSDXButton.setText("Add SDX");
                this.removeDXButton.setDisable(false);
                this.isInsertSDX = false;
                this.isRemoveDX = false;
            }
        });
        this.claimID.focusedProperty().addListener((ChangeListener)new TextFieldListener(this.claimID));
        this.dxCode.focusedProperty().addListener((ChangeListener)new TextFieldListener(this.dxCode));
        if (!App.isDebug) {
            this.baseTabPane.getTabs().remove((Object)this.referenceTableTab);
        }
        this.updateDate();
    }

    public void descriptionLookup(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof TextField) {
            TextField t = (TextField)keyEvent.getSource();
            if (t.getSelectedText().length() == t.getText().length()) {
                if (t != this.dxCode) {
                    t.clear();
                }
            } else {
                if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.BACK_SPACE || keyEvent.getCode() == KeyCode.DELETE || keyEvent.getCode() == KeyCode.HOME || keyEvent.getCode() == KeyCode.END) {
                    keyEvent.consume();
                } else {
                    int position = t.getCaretPosition();
                    t.setText(t.getText().toUpperCase().trim());
                    t.positionCaret(position);
                }
                if (t.getId().equals(this.dxCode.getId())) {
                    this.dxCodeDescription.setText(ComponentManager.getDxDescription(this.convertDXPeriods(this.dxCode.getText()), this.fromDate));
                }
            }
        }
    }

    private void loadTabAccelerators() {
        SingleSelectionModel selectionModel = this.baseTabPane.getSelectionModel();
        this.baseTabPane.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> {
            if (!this.claimInputTab.isDisable()) {
                selectionModel.select((Object)this.claimInputTab);
            }
        });
        this.baseTabPane.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> {
            if (!this.componentOutputTab.isDisable()) {
                selectionModel.select((Object)this.componentOutputTab);
            }
        });
        this.baseTabPane.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> {
            if (!this.detailedReportTab.isDisable()) {
                selectionModel.select((Object)this.detailedReportTab);
            }
        });
    }

    void loadAccelerators() {
        Platform.runLater(() -> {
            this.loadTabAccelerators();
            if (this.claimInputTab.isSelected()) {
                this.addPDXButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addPdxAction(null));
                this.addSDXButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.addSdxAction(null));
                this.removeDXButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.remDxAction(null));
                this.clearButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.clearClaimData(null));
            } else if (this.componentOutputTab.isSelected()) {
                this.saveOutputReportButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.saveReport(new ActionEvent((Object)this.saveOutputReportButton, null)));
            } else if (this.detailedReportTab.isSelected()) {
                this.saveDetailedReportButton.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), () -> this.saveReport(new ActionEvent((Object)this.saveDetailedReportButton, null)));
            }
        });
    }

    private void unloadAccelerators() {
        Platform.runLater(() -> {
            Runnable cfr_ignored_0 = (Runnable)this.baseGridPane.getScene().getAccelerators().remove((Object)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        });
    }

    private String convertDXPeriods(String s) {
        if (s.contains(".") && this.dxCode.getText().lastIndexOf(".") == 3) {
            s = s.replace(".", "");
        }
        return s;
    }

    public void runComponent() {
        this.loadAccelerators();
        ClaimInput claimInput = new ClaimInput(this.claimID.getText(), this.fromDate, (String)this.periodTimingEL.getValue(), (String)this.referralSource.getValue(), dxData, this.falls.isSelected(), this.weightLoss.isSelected(), this.multipleHospitalizations.isSelected(), this.multipleEmergency.isSelected(), this.mentalBehavior.isSelected(), this.compliance.isSelected(), this.medications.isSelected(), this.exhaustion.isSelected(), this.otherRisks.isSelected(), this.none.isSelected(), (String)this.grooming.getSelectionModel().getSelectedItem(), (String)this.dressUpper.getSelectionModel().getSelectedItem(), (String)this.dressLower.getSelectionModel().getSelectedItem(), (String)this.bathing.getSelectionModel().getSelectedItem(), (String)this.toileting.getSelectionModel().getSelectedItem(), (String)this.transferring.getSelectionModel().getSelectedItem(), (String)this.ambulation.getSelectionModel().getSelectedItem());
        Log.l(claimInput.toString(), Log.ERROR_LEVEL.DEBUG);
        HHGrouper.group(claimInput.getClaimContainer());
        Grouper grouper = new Grouper(claimInput.getClaimContainer());
        if (this.detailedReportTab.isSelected()) {
            this.detailedOutput.setText(grouper.getOutputReport(true));
            this.detailedOutput.setAccessibleText(grouper.getOutputReport(true));
            this.detailedOutput.requestFocus();
        } else if (this.componentOutputTab.isSelected()) {
            this.componentOutput.setText(grouper.getOutputReport(false));
            this.componentOutput.setAccessibleText(grouper.getOutputReport(false));
            this.componentOutput.requestFocus();
        }
    }

    public void checkM1033(ActionEvent actionEvent) {
        CheckBox input = (CheckBox)actionEvent.getSource();
        if (input.getId().equalsIgnoreCase("none") && input.isSelected()) {
            for (CheckBox n : NodeUtils.getAllCheckBoxes((Parent)this.baseGridPane)) {
                if (n.getId().equalsIgnoreCase("none")) continue;
                n.setSelected(false);
            }
            input.setDisable(true);
        } else if (!input.isSelected()) {
            boolean isCheckNone = true;
            for (CheckBox n : NodeUtils.getAllCheckBoxes((Parent)this.baseGridPane)) {
                if (n.getId().equalsIgnoreCase("none")) continue;
                isCheckNone = isCheckNone && !n.isSelected();
            }
            this.none.setSelected(isCheckNone);
            this.none.setDisable(isCheckNone);
        } else {
            this.none.setSelected(false);
            this.none.setDisable(false);
        }
    }

    public void updateDate() {
        String pattern = "yyyyMMdd";
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        NodeUtils.disableDXNodes((Parent)this.baseTabPane, true);
        if (this.fromDatePicker.getValue() != null) {
            this.fromDate = dateFormatter.format((TemporalAccessor)this.fromDatePicker.getValue());
            Log.l("From Date -> " + this.fromDate, Log.ERROR_LEVEL.DEBUG);
            if (ComponentManager.isDateValid(this.fromDate)) {
                NodeUtils.disableDXNodes((Parent)this.baseTabPane, false);
                this.periodTimingEL.requestFocus();
                dxData.forEach(e -> e.setDescription(ComponentManager.getDxDescription(e.getDiagnosis(), this.fromDate)));
                this.pdxTableView.refresh();
                if (!this.dxCode.getText().trim().isEmpty()) {
                    this.dxCodeDescription.setText(ComponentManager.getDxDescription(this.dxCode.getText().trim(), this.fromDate));
                }
            } else {
                new Popup(Alert.AlertType.ERROR, "Data Error", "Date Entry Error", "The from date entered is not within range of the component.").showAndWait();
            }
        }
    }

    public void clearClaimData(ActionEvent actionEvent) {
        if (new Popup(Alert.AlertType.CONFIRMATION, "Clear claim data?", "Are you sure you want to clear the claim data?", "").showAndWait().get() == ButtonType.OK) {
            Log.l("GUI Cleared", Log.ERROR_LEVEL.DEBUG);
            NodeUtils.clearNodes((Parent)this.baseGridPane);
            TabManager.disableTab(this.componentOutputTab, true);
            TabManager.disableTab(this.detailedReportTab, true);
            this.none.setSelected(true);
            this.none.setDisable(true);
            NodeUtils.disableDXNodes((Parent)this.baseTabPane, true);
            this.claimID.requestFocus();
            this.fromDatePicker.setValue(null);
        }
    }

    public void menuBarAction(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            Log.logButtonPress(actionEvent);
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            if (menuItem.getId().equalsIgnoreCase("about")) {
                new Popup(Alert.AlertType.INFORMATION, "About", "Internal Software Versions", this.getBuilderInfo()).showAndWait();
            } else if (menuItem.getId().equalsIgnoreCase("close") && new Popup(Alert.AlertType.CONFIRMATION, "Close the application?", "Are you sure you want to close?", "").showAndWait().get() == ButtonType.OK) {
                System.exit(0);
            }
        }
    }

    public void saveReport(ActionEvent actionEvent) {
        if (actionEvent != null && (actionEvent.getSource() == this.saveDetailedReportButton || actionEvent.getSource() == this.saveOutputReportButton)) {
            this.isSaveAccess = false;
        }
        if (!this.isSaveAccess) {
            File file = this.getFilePicker(false, ".txt");
            if (file != null) {
                Grouper.writeOutputToFile(file);
            }
            this.pdxTableView.requestFocus();
        } else {
            this.isSaveAccess = false;
        }
    }

    private File getFilePicker(boolean isDirectory, String extension) {
        Stage stage = (Stage)this.baseGridPane.getScene().getWindow();
        if (!isDirectory) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Enter file name to save");
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(extension + " files", new String[]{extension}));
            return fileChooser.showSaveDialog((Window)stage);
        }
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Enter directory to save");
        return directoryChooser.showDialog((Window)stage);
    }

    @FXML
    private void checkEnterKey(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ENTER) {
            if (this.addPDXButton.isFocused()) {
                this.addPdxAction(null);
            } else if (this.addSDXButton.isFocused()) {
                this.addSdxAction(null);
            } else if (this.removeDXButton.isFocused()) {
                this.remDxAction(null);
            } else if (this.clearButton.isFocused()) {
                this.clearClaimData(null);
            } else if (this.saveDetailedReportButton.isFocused() || this.saveOutputReportButton.isFocused()) {
                this.saveReport(null);
                this.isSaveAccess = true;
            }
        }
    }

    @FXML
    private void setGrouperTables(ActionEvent actionEvent) {
        ComponentManager componentManager = new ComponentManager((String)this.grouperVersion.getSelectionModel().getSelectedItem());
        if (componentManager.isComponentValid()) {
            ComboBoxManager.setComboBox(this.grouperTable, componentManager.getTablesForVersion());
            LabelManager.setLabelText(this.startDateLabel, "Valid From : " + componentManager.getComponentStartDate(), componentManager.isComponentValid());
            LabelManager.setLabelText(this.descriptionLabel, "Description : " + componentManager.getDescription(), componentManager.isComponentValid());
            this.exportAllButton.setDisable(false);
        } else {
            ComboBoxManager.clearComboBox(this.grouperTable);
            TableManager.clearTable(this.referenceTableView);
            TableManager.clearPage(this.referenceTablePagination);
            LabelManager.clearLabel(this.startDateLabel);
            LabelManager.clearLabel(this.descriptionLabel);
            this.exportAllButton.setDisable(true);
        }
        this.referenceTablePagination.currentPageIndexProperty().addListener(observable -> this.getRTData((Event)actionEvent));
    }

    @FXML
    public void getRTData(Event event) {
        if (this.grouperTable.getSelectionModel().getSelectedIndex() > 0) {
            if (event.getSource() == this.grouperTable) {
                TextFieldManager.clearTextFields(TableManager.getFilterTextFields(this.referenceTableView));
                this.exportViewButton.setDisable(false);
                this.exportTableButton.setDisable(false);
                TableManager.clearPage(this.referenceTablePagination);
            }
            this.initTableWithNewPage();
            for (Object c : this.referenceTableView.getColumns()) {
                ((Node)((VBox)((TableColumn)c).getGraphic()).getChildren().get(1)).setOnKeyPressed(this::getFilterColumnID);
                ((Node)((VBox)((TableColumn)c).getGraphic()).getChildren().get(1)).setOnKeyReleased(this::handleFilterKeys);
            }
        } else {
            TableManager.clearTable(this.referenceTableView);
            this.exportViewButton.setDisable(true);
            this.exportTableButton.setDisable(true);
            TableManager.clearPage(this.referenceTablePagination);
        }
    }

    private void getFilterColumnID(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.SHIFT) {
            keyEvent.consume();
        } else {
            this.selectedTextField = (TextField)keyEvent.getSource();
            this.lastKeyPress = keyEvent.getCode();
        }
    }

    private void handleFilterKeys(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.SHIFT || this.lastKeyPress == KeyCode.TAB) {
            keyEvent.consume();
        } else {
            this.initTableWithNewPage();
            try {
                Thread.sleep(20L);
                Platform.runLater(() -> {
                    for (Object c : this.referenceTableView.getColumns()) {
                        VBox v = (VBox)((TableColumn)c).getGraphic();
                        TextField t = (TextField)v.getChildren().get(1);
                        t.setOnKeyPressed(this::getFilterColumnID);
                        t.setOnKeyReleased(keyEvent1 -> this.handleFilterKeys(keyEvent));
                        if (keyEvent.getCode() == KeyCode.TAB || !t.getId().equals(this.selectedTextField.getId())) continue;
                        t.requestFocus();
                        t.selectRange(t.getText().length(), t.getText().length());
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> void initTableWithNewPage() {
        ComponentManager componentManager = new ComponentManager((String)this.grouperVersion.getSelectionModel().getSelectedItem(), (String)this.grouperTable.getSelectionModel().getSelectedItem(), TableManager.getFilterValues(this.referenceTableView));
        ObservableList rtData = componentManager.getFilteredRT();
        TableManager.setPagenation(this.referenceTablePagination, rtData.size(), this.MAX_ROWS_IN_PAGE);
        TableManager.initTable(this.referenceTableView, componentManager.getRotForPage(this.referenceTablePagination.getCurrentPageIndex(), this.referenceTablePagination.getPageCount(), (int)this.MAX_ROWS_IN_PAGE), (String)this.grouperTable.getSelectionModel().getSelectedItem(), TableManager.getFilterValues(this.referenceTableView), previousRFSelection);
        previousRFSelection = (String)this.grouperTable.getSelectionModel().getSelectedItem();
    }

    @FXML
    private void exportRots(ActionEvent actionEvent) {
        Log.logButtonPress(actionEvent);
        String buttonID = ((Button)actionEvent.getSource()).getId();
        if (buttonID.equalsIgnoreCase("exportViewButton")) {
            TableManager.exportToCSV(new ComponentManager((String)this.grouperVersion.getSelectionModel().getSelectedItem(), (String)this.grouperTable.getSelectionModel().getSelectedItem(), TableManager.getFilterValues(this.referenceTableView)), this.getFilePicker(false, ".csv").getAbsolutePath(), true);
        } else if (buttonID.equalsIgnoreCase("exportTableButton")) {
            TableManager.exportToCSV(new ComponentManager((String)this.grouperVersion.getSelectionModel().getSelectedItem(), (String)this.grouperTable.getSelectionModel().getSelectedItem(), TableManager.getFilterValues(this.referenceTableView)), this.getFilePicker(false, ".csv").getAbsolutePath(), false);
        } else if (buttonID.equalsIgnoreCase("exportAllButton")) {
            String path = this.getFilePicker(true, ".csv").getAbsolutePath() + "/";
            for (String t : this.grouperTable.getItems()) {
                if (t.equalsIgnoreCase("None")) continue;
                TableManager.exportToCSV(new ComponentManager((String)this.grouperVersion.getSelectionModel().getSelectedItem(), t, TableManager.getFilterValues(this.referenceTableView)), path + t + ".csv", false);
            }
        }
    }

    private String getBuilderInfo() {
        return "Internal Batch: " + HHGrouper.getBuildInfo() + "\nGUI: Software: " + Controller.class.getPackage().getSpecificationTitle() + ", Version: " + Controller.class.getPackage().getSpecificationVersion();
    }

    @FXML
    private void accessibleComboBoxChanged(KeyEvent keyEvent) {
        ComboBox comboBox = (ComboBox)keyEvent.getSource();
        this.pdxTableView.requestFocus();
        comboBox.setAccessibleText((String)comboBox.getSelectionModel().getSelectedItem());
        comboBox.requestFocus();
    }
}

