/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.diagnosis.ComorbidityGroupIF;
import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

public class ComorbidityGroup
implements ComorbidityGroupIF,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private String description;
    private boolean lowComorbidity;

    public ComorbidityGroup() {
    }

    public String toString() {
        return "ComorbidityGroup{id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", lowComorbidity=" + this.lowComorbidity + '}';
    }

    public ComorbidityGroup(int id, String name, String description, boolean lowComorbidity) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.lowComorbidity = lowComorbidity;
    }

    public ComorbidityGroup(int id, ComorbidityGroupObject cgo) throws ParseException {
        this(id, cgo.getName(), cgo.getDescription(), Integer.parseInt(cgo.getLowComorbidityFlag()) > 0);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isLowComorbidity() {
        return this.lowComorbidity;
    }

    @Override
    public void setLowComorbidity(boolean lowComorbidity) {
        this.lowComorbidity = lowComorbidity;
    }

    @Override
    public boolean isComorbidityPresent() {
        List<String> INVALID_VALUES = Arrays.asList("", "no_group", "no", "0", "no group");
        return !INVALID_VALUES.contains(this.name.toLowerCase().trim());
    }
}

