/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.ValuableIF;
import java.io.Serializable;

/**
 *
 * @author CMS
 */
public class ValidityFlag implements ValuableIF, DescribableIF, Serializable{

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "ValidityFlag{" + "value=" + value + ", description=" + description + '}';
    }

    /**
     * Constructor
     */
    public ValidityFlag() {
    }

    /**
     *
     * @param value
     * @param description
     */
    public ValidityFlag(String value, String description) {
        this.value = value;
        this.description = description;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    private String value;
    private String description;
    
}
