/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.files;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;

/**
 *
 * @author CMS
 */
public enum TableNames_EN implements DescribableIF, IdentifiableIF {

    // Table Names

    // Reference Tables (ROT)

    /**
     *
     */
    Diagnoses(0,"Diagnoses", "Diagnosis_Codes.txt", true),

    /**
     *
     */
    Clinical_Groups(1,"Clinical Groups", "Clinical_Groups.txt", true),

    /**
     *
     */
    Comorbidity_Groups(2,"Comorbidity Groups", "Comorbidity_Groups.txt", true),

    /**
     *
     */
    Comorbidity_Interactions(3,"Comorbidity Interactions", "Comorbidity_Interactions.txt", true),

    /**
     *
     */
    Diagnosis_Subchapters(4,"Diagnosis Subchapters", "Diagnosis_Subchapters.txt", true),

    /**
     *
     */
    HIPPS_Structure(5,"HIPPS Structure", "HIPPS_Structure.txt", true),

    /**
     *
     */
    OASIS_Responses(6,"FI Responses", "FI_Responses.txt", false),

    /**
     *
     */
    Return_Codes(7,"Return Codes", "Return_Codes.txt", false),

    // Version Table

    /**
     *
     */
    Grouper_Versions(8,"Grouper Versions", "Version_Range.txt", false),

    // Claim Layout Table

    /**
     *
     */
    Claim_Layout(9,"Claim Layout", "Claim_Layout.txt", false)
    
    ;
    
    private String fileName;
    private String description;
    private int id;
    private boolean viewable;

    private TableNames_EN(int id, String description, String fileName, boolean viewable) {
        this.id = id;
        this.description = description;
        this.fileName = fileName;
        this.viewable = viewable;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the fileName
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * @param fileName the fileName to set
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * @return the viewable
     */
    public boolean isViewable() {
        return viewable;
    }

    /**
     * @param viewable the viewable to set
     */
    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

}
