/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification.condition;

import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import gov.cms.hh.logic.specification.abstr.AndSpecification;
import gov.cms.hh.logic.specification.abstr.OrSpecification;
import gov.cms.hh.logic.specification.abstr.Specification;
import gov.cms.hh.logic.specification.condition.RangeCondition;
import gov.cms.hh.logic.specification.condition.RegexCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConditionSpecificationBuilder {
    final String DELIMITER_OR = ";";
    final String DELIMITER_AND = "&";

    public Specification<String> buildConditionSpecifications(String conditions) {
        Specification<String> retSpec = this.parseConditions(conditions == null ? "" : conditions);
        return retSpec;
    }

    protected Specification<String> parseConditions(String conditions) {
        OrSpecification retSpec = null;
        List<String> condList = Arrays.asList(conditions.split(";"));
        ArrayList<Specification<String>> condSpecList = new ArrayList<Specification<String>>();
        for (String string : condList) {
            if (string.contains("&")) {
                condSpecList.add(this.buildMultiAndSpec(string));
                continue;
            }
            condSpecList.add(this.buildSingleSpec(string));
        }
        if (!condSpecList.isEmpty()) {
            for (Specification specification : condSpecList) {
                if (retSpec == null) {
                    retSpec = new OrSpecification(specification, specification);
                    continue;
                }
                retSpec.or(specification);
            }
        }
        return retSpec;
    }

    protected Specification<String> buildSingleSpec(String specItem) {
        AbstractSpecification retSpec = null;
        if (specItem.startsWith("<")) {
            String[] minMax = specItem.replaceAll("<", "").replaceAll(">", "").split("-");
            retSpec = new RangeCondition(minMax[0], minMax[1]);
        } else {
            retSpec = new RegexCondition(specItem);
        }
        return retSpec;
    }

    protected Specification<String> buildMultiAndSpec(String specItem) {
        AndSpecification retSpec = null;
        List<String> andCondList = Arrays.asList(specItem.split("&"));
        ArrayList<Specification<String>> condSpecList = new ArrayList<Specification<String>>();
        for (String string : andCondList) {
            condSpecList.add(this.buildSingleSpec(string));
        }
        if (!condSpecList.isEmpty()) {
            for (Specification specification : condSpecList) {
                if (retSpec == null) {
                    retSpec = new AndSpecification(specification, specification);
                    continue;
                }
                retSpec.and(specification);
            }
        }
        return retSpec;
    }
}

