/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.common.abstr.EditableIF;
import gov.cms.hh.reference.objects.HippsValueObject;
import java.util.Map;

/**
 *
 * @author CMS
 */
public interface HippsCodeIF extends EditableIF {

    /**
     * @return the hipps
     */
    Map<Integer, HippsValueObject> getHipps();

    /**
     * @param hipps the hipps to set
     */
    void setHipps(Map<Integer, HippsValueObject> hipps);

    /**
     *
     * @param value
     * @return
     */
    boolean setValue(HippsValueObject value);

    /**
     *
     * @return
     */
    String getHippsCode();
    
    /**
     *
     * @return
     */
    String getFinalHippsCode();

    /**
     *
     * @param position
     * @return
     */
    String getHippsCharacter(int position);

    /**
     *
     * @param position
     * @return
     */
    HippsValueObject getValue(int position);
    
    /**
     *
     * @return
     */
    boolean isHippsComplete();

}
