/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification.condition;

import gov.cms.hh.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author CMS
 */
public class RangeCondition extends AbstractSpecification<String> {

    private final String min;
    private final String max;

    /**
     *
     * @param min
     * @param max
     */
    public RangeCondition(String min, String max) {
        this.min = min;
        this.max = max;
    }

    /**
     *
     * @param dx
     * @return
     */
    @Override
    public boolean isSatisfiedBy(String dx) {
        if(dx.trim().isEmpty()) {
            return false; // "Empty" DX doesn't meet any range
        }
        if(min.trim().isEmpty() && min.trim().isEmpty()) {
            return true; // Any DX meets "empty" range - Specs for v04.1.23
        }
        if(dx.trim().toUpperCase().compareTo(min.trim().toUpperCase()) >= 0
                && dx.trim().toUpperCase().compareTo(max.trim().toUpperCase()) <= 0) {
            return true;
        }
        return false;
    }

}
