package gov.cms.hh.v04223;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.IsSpanClaim;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

/**
 *
 * @author US340646
 */
public class IsSpanClaim_v04223 extends IsSpanClaim {
    
    public IsSpanClaim_v04223(String date) {
        super(date);
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDaysInRange(gv.getEndDate());
    }

    /**
     *
     * @param versionEnd
     * @return
     */
    @Override
    protected boolean isDaysInRange(final Date versionEnd) {
        if (getDate() == null) {
            return false;
        }
        // Convert to Local Date as more safe for day range calculation 
        LocalDate claimEndDate = getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate verEndDate = versionEnd.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // If span 
        long days = ChronoUnit.DAYS.between(verEndDate, claimEndDate);
        return (days > 0);
    }
    
}
