/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jetty9;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class InstrumentedConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final ConnectionFactory connectionFactory;
    private final Timer timer;
    private final Counter counter;

    public InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer) {
        this(connectionFactory, timer, null);
    }

    public InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer, Counter counter) {
        this.connectionFactory = connectionFactory;
        this.timer = timer;
        this.counter = counter;
        this.addBean(connectionFactory);
    }

    @Override
    public String getProtocol() {
        return this.connectionFactory.getProtocol();
    }

    @Override
    public List<String> getProtocols() {
        return this.connectionFactory.getProtocols();
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Connection connection = this.connectionFactory.newConnection(connector, endPoint);
        connection.addListener(new Connection.Listener(){
            private Timer.Context context;

            @Override
            public void onOpened(Connection connection) {
                this.context = InstrumentedConnectionFactory.this.timer.time();
                if (InstrumentedConnectionFactory.this.counter != null) {
                    InstrumentedConnectionFactory.this.counter.inc();
                }
            }

            @Override
            public void onClosed(Connection connection) {
                this.context.stop();
                if (InstrumentedConnectionFactory.this.counter != null) {
                    InstrumentedConnectionFactory.this.counter.dec();
                }
            }
        });
        return connection;
    }
}

