/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api.validation;

import gov.cms.fiss.pricers.common.api.validation.RelativeDate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class RelativeDateValidator
implements ConstraintValidator<RelativeDate, LocalDate> {
    private boolean isExclusiveComparison;
    private LocalDate comparisonDate;
    private RelativeDate.ComparisonMode comparisonMode;

    @Override
    public void initialize(RelativeDate constraintAnnotation) {
        this.isExclusiveComparison = constraintAnnotation.exclusive();
        this.comparisonMode = constraintAnnotation.comparisonMode();
        this.comparisonDate = DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)constraintAnnotation.value(), LocalDate::from);
    }

    @Override
    public boolean isValid(LocalDate value, ConstraintValidatorContext context) {
        if (null == value) {
            return true;
        }
        boolean relativePosition = this.comparisonMode.comparison.test(this.comparisonDate, value);
        if (!relativePosition && !this.isExclusiveComparison) {
            return value.equals(this.comparisonDate);
        }
        return relativePosition;
    }
}

