/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.filters;

import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.math.NumberUtils;

@Priority(value=4000)
public class ContentLengthFilter
implements Filter {
    public static final int DEFAULT_MAXIMUM_REQUEST_SIZE = 102400;
    public static final String PROPERTY_MAX_REQUEST_SIZE = "maximumRequestSize";
    private int maximumRequestSize = 102400;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String maxRequestSizeConfig = filterConfig.getInitParameter(PROPERTY_MAX_REQUEST_SIZE);
        this.maximumRequestSize = NumberUtils.toInt(maxRequestSizeConfig, 102400);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int contentLength = request.getContentLength();
        if (contentLength <= this.maximumRequestSize) {
            chain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendError(413, String.format("Payload exceeds pricer limits: %s", contentLength));
        }
    }
}

