/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.ltch.LtchPricerConfiguration;
import gov.cms.fiss.pricers.ltch.core.LtchPricerDispatch;
import gov.cms.fiss.pricers.ltch.resources.InpatientDrgEntryResource;
import gov.cms.fiss.pricers.ltch.resources.LtchClaimPricingResource;
import gov.cms.fiss.pricers.ltch.resources.LtchDrgEntryResource;
import gov.cms.fiss.pricers.ltch.resources.LtchExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtchPricerApplication
extends OpenApiPricerApplication<LtchPricerConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LtchPricerApplication.class);

    public static void main(String[] args) throws Exception {
        new LtchPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(LtchPricerConfiguration pricerConfiguration, Environment environment) {
        LtchClaimPricingResource v2Resource = new LtchClaimPricingResource(new LtchPricerDispatch(pricerConfiguration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new InpatientDrgEntryResource(pricerConfiguration));
        environment.jersey().register(new LtchDrgEntryResource(pricerConfiguration));
        environment.jersey().register(new CbsaWageIndexResource(pricerConfiguration, LtchExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("LTCH Pricer").version("v1")));
        return customizers;
    }

    @Override
    public String getName() {
        return "ltch-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(LtchClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.2", 2021, "2021.2", 2022, "2022.0", 2023, "2023.0", 2024, "2024.0", 2025, "2025.1");
    }
}

