/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The LTCH claim data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-NEW-DATA", value="<structure>")})})
public class LtchClaimData
extends ClaimData {
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The number of cost report days.", example="10", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-CST-RPT-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int costReportDays;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @NotNull
    @Schema(description="The covered charges.", example="950.80", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-COV-CHARGES", value="PIC 9(07)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) @NotNull BigDecimal coveredCharges;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of covered days.", example="23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-COV-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer coveredDays;
    @ArraySchema(arraySchema=@Schema(description="The diagnosis codes related to this code.", example="[ \"N390\", \"B952\", \"I130\", \"I5032\", \"N179\", \"M25511\", \"M549\" ]"), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DIAGNOSIS-CODE-TABLE", value="B-DIAGNOSIS-CODE  PIC X(07) OCCURS 25 TIMES")})})
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be between one and seven characters") String> diagnosisCodes;
    @NotNull
    @Schema(description="The diagnosis-related group.", example="003", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DRG-CODE", value="PIC 9(03)")})})
    @ValidDiagnosisRelatedGroup
    private String diagnosisRelatedGroup;
    @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character")
    @Schema(description="The diagnosis-related group severity.", example="1")
    private @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character") String diagnosisRelatedGroupSeverity;
    @NotNull
    @Schema(description="The discharge date.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DISCHARGE-DATE", value="B-DISCHG-CC  PIC 9(02)\nB-DISCHG-YY  PIC 9(02)\nB-DISCHG-MM  PIC 9(02)\nB-DISCHG-DD  PIC 9(02)")})})
    @StrictLocalDate
    private LocalDate dischargeDate;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The length of stay (LOS).", example="5", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LOS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer lengthOfStay;
    @Max(value=99L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of lifetime reserve days.", example="6", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LTR-DAYS", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) @NotNull Integer lifetimeReserveDays;
    @Pattern(regexp="1", message="must be `1` if present")
    @Schema(description="The outlier special payment indicator.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-SPEC-PAY-IND", value="PIC X(01)")})})
    private @Pattern(regexp="1", message="must be `1` if present") String outlierSpecialPaymentIndicator;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The patient status.", example="02", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PATIENT-STATUS", value="PIC X(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be two digits") String patientStatus;
    @ArraySchema(arraySchema=@Schema(description="The procedure codes related to this claim.", example="[\"04VD3FZ\", \"XNS0032\", \"XW033F3\", \"3E0J7U1\"]"), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PROCEDURE-CODE-TABLE", value="B-PROCEDURE-CODE  PIC X(07) OCCURS 25 TIMES")})})
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{7}", message="must be seven characters") String> procedureCodes;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The code documenting the state of claim review.", example="07", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-REVIEW-CODE", value="PIC 9(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be two digits") String reviewCode;

    @Generated
    public int getCostReportDays() {
        return this.costReportDays;
    }

    @Generated
    public BigDecimal getCoveredCharges() {
        return this.coveredCharges;
    }

    @Generated
    public Integer getCoveredDays() {
        return this.coveredDays;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be between one and seven characters") String> getDiagnosisCodes() {
        return this.diagnosisCodes;
    }

    @Generated
    public String getDiagnosisRelatedGroup() {
        return this.diagnosisRelatedGroup;
    }

    @Generated
    public String getDiagnosisRelatedGroupSeverity() {
        return this.diagnosisRelatedGroupSeverity;
    }

    @Generated
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public Integer getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public Integer getLifetimeReserveDays() {
        return this.lifetimeReserveDays;
    }

    @Generated
    public String getOutlierSpecialPaymentIndicator() {
        return this.outlierSpecialPaymentIndicator;
    }

    @Generated
    public String getPatientStatus() {
        return this.patientStatus;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{7}", message="must be seven characters") String> getProcedureCodes() {
        return this.procedureCodes;
    }

    @Generated
    public String getReviewCode() {
        return this.reviewCode;
    }

    @Generated
    public void setCostReportDays(int costReportDays) {
        this.costReportDays = costReportDays;
    }

    @Generated
    public void setCoveredCharges(BigDecimal coveredCharges) {
        this.coveredCharges = coveredCharges;
    }

    @Generated
    public void setCoveredDays(Integer coveredDays) {
        this.coveredDays = coveredDays;
    }

    @Generated
    public void setDiagnosisCodes(List<@Pattern(regexp="[A-Z\\d]{1,7}", message="must be between one and seven characters") String> diagnosisCodes) {
        this.diagnosisCodes = diagnosisCodes;
    }

    @Generated
    public void setDiagnosisRelatedGroup(String diagnosisRelatedGroup) {
        this.diagnosisRelatedGroup = diagnosisRelatedGroup;
    }

    @Generated
    public void setDiagnosisRelatedGroupSeverity(String diagnosisRelatedGroupSeverity) {
        this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
    }

    @Generated
    public void setDischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Generated
    public void setLengthOfStay(Integer lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setLifetimeReserveDays(Integer lifetimeReserveDays) {
        this.lifetimeReserveDays = lifetimeReserveDays;
    }

    @Generated
    public void setOutlierSpecialPaymentIndicator(String outlierSpecialPaymentIndicator) {
        this.outlierSpecialPaymentIndicator = outlierSpecialPaymentIndicator;
    }

    @Generated
    public void setPatientStatus(String patientStatus) {
        this.patientStatus = patientStatus;
    }

    @Generated
    public void setProcedureCodes(List<@Pattern(regexp="[A-Z\\d]{7}", message="must be seven characters") String> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    @Generated
    public void setReviewCode(String reviewCode) {
        this.reviewCode = reviewCode;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LtchClaimData)) {
            return false;
        }
        LtchClaimData other = (LtchClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCostReportDays() != other.getCostReportDays()) {
            return false;
        }
        Integer this$coveredDays = this.getCoveredDays();
        Integer other$coveredDays = other.getCoveredDays();
        if (this$coveredDays == null ? other$coveredDays != null : !((Object)this$coveredDays).equals(other$coveredDays)) {
            return false;
        }
        Integer this$lengthOfStay = this.getLengthOfStay();
        Integer other$lengthOfStay = other.getLengthOfStay();
        if (this$lengthOfStay == null ? other$lengthOfStay != null : !((Object)this$lengthOfStay).equals(other$lengthOfStay)) {
            return false;
        }
        Integer this$lifetimeReserveDays = this.getLifetimeReserveDays();
        Integer other$lifetimeReserveDays = other.getLifetimeReserveDays();
        if (this$lifetimeReserveDays == null ? other$lifetimeReserveDays != null : !((Object)this$lifetimeReserveDays).equals(other$lifetimeReserveDays)) {
            return false;
        }
        BigDecimal this$coveredCharges = this.getCoveredCharges();
        BigDecimal other$coveredCharges = other.getCoveredCharges();
        if (this$coveredCharges == null ? other$coveredCharges != null : !((Object)this$coveredCharges).equals(other$coveredCharges)) {
            return false;
        }
        List<String> this$diagnosisCodes = this.getDiagnosisCodes();
        List<String> other$diagnosisCodes = other.getDiagnosisCodes();
        if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !((Object)this$diagnosisCodes).equals(other$diagnosisCodes)) {
            return false;
        }
        String this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        String other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
        if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) {
            return false;
        }
        String this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        String other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
        if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) {
            return false;
        }
        LocalDate this$dischargeDate = this.getDischargeDate();
        LocalDate other$dischargeDate = other.getDischargeDate();
        if (this$dischargeDate == null ? other$dischargeDate != null : !((Object)this$dischargeDate).equals(other$dischargeDate)) {
            return false;
        }
        String this$outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
        String other$outlierSpecialPaymentIndicator = other.getOutlierSpecialPaymentIndicator();
        if (this$outlierSpecialPaymentIndicator == null ? other$outlierSpecialPaymentIndicator != null : !this$outlierSpecialPaymentIndicator.equals(other$outlierSpecialPaymentIndicator)) {
            return false;
        }
        String this$patientStatus = this.getPatientStatus();
        String other$patientStatus = other.getPatientStatus();
        if (this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus)) {
            return false;
        }
        List<String> this$procedureCodes = this.getProcedureCodes();
        List<String> other$procedureCodes = other.getProcedureCodes();
        if (this$procedureCodes == null ? other$procedureCodes != null : !((Object)this$procedureCodes).equals(other$procedureCodes)) {
            return false;
        }
        String this$reviewCode = this.getReviewCode();
        String other$reviewCode = other.getReviewCode();
        return !(this$reviewCode == null ? other$reviewCode != null : !this$reviewCode.equals(other$reviewCode));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LtchClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCostReportDays();
        Integer $coveredDays = this.getCoveredDays();
        result = result * 59 + ($coveredDays == null ? 43 : ((Object)$coveredDays).hashCode());
        Integer $lengthOfStay = this.getLengthOfStay();
        result = result * 59 + ($lengthOfStay == null ? 43 : ((Object)$lengthOfStay).hashCode());
        Integer $lifetimeReserveDays = this.getLifetimeReserveDays();
        result = result * 59 + ($lifetimeReserveDays == null ? 43 : ((Object)$lifetimeReserveDays).hashCode());
        BigDecimal $coveredCharges = this.getCoveredCharges();
        result = result * 59 + ($coveredCharges == null ? 43 : ((Object)$coveredCharges).hashCode());
        List<String> $diagnosisCodes = this.getDiagnosisCodes();
        result = result * 59 + ($diagnosisCodes == null ? 43 : ((Object)$diagnosisCodes).hashCode());
        String $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        result = result * 59 + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
        String $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        result = result * 59 + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
        LocalDate $dischargeDate = this.getDischargeDate();
        result = result * 59 + ($dischargeDate == null ? 43 : ((Object)$dischargeDate).hashCode());
        String $outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
        result = result * 59 + ($outlierSpecialPaymentIndicator == null ? 43 : $outlierSpecialPaymentIndicator.hashCode());
        String $patientStatus = this.getPatientStatus();
        result = result * 59 + ($patientStatus == null ? 43 : $patientStatus.hashCode());
        List<String> $procedureCodes = this.getProcedureCodes();
        result = result * 59 + ($procedureCodes == null ? 43 : ((Object)$procedureCodes).hashCode());
        String $reviewCode = this.getReviewCode();
        result = result * 59 + ($reviewCode == null ? 43 : $reviewCode.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LtchClaimData(costReportDays=" + this.getCostReportDays() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", outlierSpecialPaymentIndicator=" + this.getOutlierSpecialPaymentIndicator() + ", patientStatus=" + this.getPatientStatus() + ", procedureCodes=" + this.getProcedureCodes() + ", reviewCode=" + this.getReviewCode() + ")";
    }

    @Generated
    public LtchClaimData() {
    }
}

