/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFiveFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The LTCH payment information.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DATA-ALL", value="<structure>")})})
public class LtchPaymentData
extends PaymentData {
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The adjusted payment.", example="3523.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DRG-ADJ-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal adjustedPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=1)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9")
    @Digits(integer=2, fraction=1)
    @NotNull
    @Schema(description="The average length of stay.", example="8.2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-AVG-LOS", value="PIC 9(02)V9(01)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.9") @Digits(integer=2, fraction=1) @NotNull @FixedValue BigDecimal averageLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
    @Max(value=9L)
    @Min(value=1L)
    @Schema(description="The blend year.", example="4", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BLEND-YEAR", value="PIC 9(01)")})})
    private @Max(value=9L) @Min(value=1L) int blendYear;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The budget neutrality rate amount.", example="6.999", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BDGT-NEUT-RATE", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal budgetNeutralityRate = BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP);
    @Pattern(regexp="1", message="must be `1` if present")
    @Schema(description="The change of therapy indicator.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-COT", value="PIC X(01)")})})
    private @Pattern(regexp="1", message="must be `1` if present") String changeOfTherapyIndicator;
    @BigDecimalScale
    @Schema(description="The charge threshold payment amount.", example="25953.12", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CHRG-THRESHOLD", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal chargeThresholdAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The cost-of-living adjustment of provider record.", example="0.998", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-COLA", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal costOfLivingAdjustmentPercent = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @DecimalMax(value="99999999999999999999.9999")
    @DecimalMin(value="-99999999999999999999.9999")
    @Digits(integer=20, fraction=4)
    @Schema(description="The discharge payment percent amount.", example="0.4215")
    private @DecimalMax(value="99999999999999999999.9999") @DecimalMin(value="-99999999999999999999.9999") @Digits(integer=20, fraction=4) BigDecimal dischargePaymentPercentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @NotNull
    @Schema(description="The diagnosis-related group (DRG) relative weight.", example="5.2903", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-RELATIVE-WGT", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @NotNull @FixedValue BigDecimal drgRelativeWeight = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
    @BigDecimalScale
    @Schema(description="The facility costs.", example="3256.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FAC-COSTS", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal facilityCosts = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The facility-specific rate.", example="1902.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NEW-FAC-SPEC-RATE", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal facilitySpecificRate = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The federal payment.", example="58399.00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FED-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal federalPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=5)
    @Schema(description="The federal rate percent.", example="0.59283")
    @ValidDecimalOutputWithFiveFractionDigits
    private BigDecimal federalRatePercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=1)
    @DecimalMin(value="0")
    @DecimalMax(value="999.9")
    @Digits(integer=3, fraction=1)
    @Schema(description="The inpatient threshold.", example="253.9", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-IPTHRESH", value="PIC 9(03)V9(01)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="999.9") @Digits(integer=3, fraction=1) @FixedValue BigDecimal inpatientThreshold = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The length of stay (LOS).", example="4", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LOS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int lengthOfStay;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The number of lifetime reserve days used.", example="12", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LTR-DAYS-USED", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int lifetimeReserveDaysUsed;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99999")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national labor percent.", example="0.53226", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-LABOR-PCT", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99999") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99999")
    @Digits(integer=1, fraction=5)
    @Schema(description="The national non-labor percent.", example="0.35232", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-NONLABOR-PCT", value="PIC 9(01)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99999") @Digits(integer=1, fraction=5) @FixedValue BigDecimal nationalNonLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
    @BigDecimalScale
    @NotNull
    @Schema(description="The outlier payment.", example="9355.24", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUTLIER-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The outlier threshold amount.", example="55246.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUTLIER-THRESHOLD", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The number of regular days used.", example="30", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-DAYS-USED", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int regularDaysUsed;
    @BigDecimalScale
    @Schema(description="The site-neutral cost payment.", example="15323.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-SITE-NEUTRAL-COST-PMT", value="PIC 9(07)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal siteNeutralCostPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The site-neutral IPPS payment.", example="5582.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-SITE-NEUTRAL-IPPS-PMT", value="PIC 9(07)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal siteNeutralIppsPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The standard full payment.", example="5883.00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-STANDARD-FULL-PMT", value="PIC 9(07)V99")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal standardFullPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The standard short-stay outlier payment.", example="35266.80", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-STANDARD-SSO-PMT", value="PIC 9(07)V99")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal standardShortStayOutlierPayment = BigDecimalUtils.ZERO;
    @ValidDiagnosisRelatedGroup
    @Schema(description="The submitted diagnosis-related group.", example="981", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-SUBM-DRG-CODE", value="PIC X(03)")})})
    private String submittedDiagnosisRelatedGroup;

    @Generated
    public BigDecimal getAdjustedPayment() {
        return this.adjustedPayment;
    }

    @Generated
    public BigDecimal getAverageLengthOfStay() {
        return this.averageLengthOfStay;
    }

    @Generated
    public int getBlendYear() {
        return this.blendYear;
    }

    @Generated
    public BigDecimal getBudgetNeutralityRate() {
        return this.budgetNeutralityRate;
    }

    @Generated
    public String getChangeOfTherapyIndicator() {
        return this.changeOfTherapyIndicator;
    }

    @Generated
    public BigDecimal getChargeThresholdAmount() {
        return this.chargeThresholdAmount;
    }

    @Generated
    public BigDecimal getCostOfLivingAdjustmentPercent() {
        return this.costOfLivingAdjustmentPercent;
    }

    @Generated
    public BigDecimal getDischargePaymentPercentAmount() {
        return this.dischargePaymentPercentAmount;
    }

    @Generated
    public BigDecimal getDrgRelativeWeight() {
        return this.drgRelativeWeight;
    }

    @Generated
    public BigDecimal getFacilityCosts() {
        return this.facilityCosts;
    }

    @Generated
    public BigDecimal getFacilitySpecificRate() {
        return this.facilitySpecificRate;
    }

    @Generated
    public BigDecimal getFederalPayment() {
        return this.federalPayment;
    }

    @Generated
    public BigDecimal getFederalRatePercent() {
        return this.federalRatePercent;
    }

    @Generated
    public BigDecimal getInpatientThreshold() {
        return this.inpatientThreshold;
    }

    @Generated
    public int getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public int getLifetimeReserveDaysUsed() {
        return this.lifetimeReserveDaysUsed;
    }

    @Generated
    public BigDecimal getNationalLaborPercent() {
        return this.nationalLaborPercent;
    }

    @Generated
    public BigDecimal getNationalNonLaborPercent() {
        return this.nationalNonLaborPercent;
    }

    @Generated
    public BigDecimal getOutlierPayment() {
        return this.outlierPayment;
    }

    @Generated
    public BigDecimal getOutlierThresholdAmount() {
        return this.outlierThresholdAmount;
    }

    @Generated
    public int getRegularDaysUsed() {
        return this.regularDaysUsed;
    }

    @Generated
    public BigDecimal getSiteNeutralCostPayment() {
        return this.siteNeutralCostPayment;
    }

    @Generated
    public BigDecimal getSiteNeutralIppsPayment() {
        return this.siteNeutralIppsPayment;
    }

    @Generated
    public BigDecimal getStandardFullPayment() {
        return this.standardFullPayment;
    }

    @Generated
    public BigDecimal getStandardShortStayOutlierPayment() {
        return this.standardShortStayOutlierPayment;
    }

    @Generated
    public String getSubmittedDiagnosisRelatedGroup() {
        return this.submittedDiagnosisRelatedGroup;
    }

    @Generated
    public void setAdjustedPayment(BigDecimal adjustedPayment) {
        this.adjustedPayment = adjustedPayment;
    }

    @Generated
    public void setAverageLengthOfStay(BigDecimal averageLengthOfStay) {
        this.averageLengthOfStay = averageLengthOfStay;
    }

    @Generated
    public void setBlendYear(int blendYear) {
        this.blendYear = blendYear;
    }

    @Generated
    public void setBudgetNeutralityRate(BigDecimal budgetNeutralityRate) {
        this.budgetNeutralityRate = budgetNeutralityRate;
    }

    @Generated
    public void setChangeOfTherapyIndicator(String changeOfTherapyIndicator) {
        this.changeOfTherapyIndicator = changeOfTherapyIndicator;
    }

    @Generated
    public void setChargeThresholdAmount(BigDecimal chargeThresholdAmount) {
        this.chargeThresholdAmount = chargeThresholdAmount;
    }

    @Generated
    public void setCostOfLivingAdjustmentPercent(BigDecimal costOfLivingAdjustmentPercent) {
        this.costOfLivingAdjustmentPercent = costOfLivingAdjustmentPercent;
    }

    @Generated
    public void setDischargePaymentPercentAmount(BigDecimal dischargePaymentPercentAmount) {
        this.dischargePaymentPercentAmount = dischargePaymentPercentAmount;
    }

    @Generated
    public void setDrgRelativeWeight(BigDecimal drgRelativeWeight) {
        this.drgRelativeWeight = drgRelativeWeight;
    }

    @Generated
    public void setFacilityCosts(BigDecimal facilityCosts) {
        this.facilityCosts = facilityCosts;
    }

    @Generated
    public void setFacilitySpecificRate(BigDecimal facilitySpecificRate) {
        this.facilitySpecificRate = facilitySpecificRate;
    }

    @Generated
    public void setFederalPayment(BigDecimal federalPayment) {
        this.federalPayment = federalPayment;
    }

    @Generated
    public void setFederalRatePercent(BigDecimal federalRatePercent) {
        this.federalRatePercent = federalRatePercent;
    }

    @Generated
    public void setInpatientThreshold(BigDecimal inpatientThreshold) {
        this.inpatientThreshold = inpatientThreshold;
    }

    @Generated
    public void setLengthOfStay(int lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setLifetimeReserveDaysUsed(int lifetimeReserveDaysUsed) {
        this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
    }

    @Generated
    public void setNationalLaborPercent(BigDecimal nationalLaborPercent) {
        this.nationalLaborPercent = nationalLaborPercent;
    }

    @Generated
    public void setNationalNonLaborPercent(BigDecimal nationalNonLaborPercent) {
        this.nationalNonLaborPercent = nationalNonLaborPercent;
    }

    @Generated
    public void setOutlierPayment(BigDecimal outlierPayment) {
        this.outlierPayment = outlierPayment;
    }

    @Generated
    public void setOutlierThresholdAmount(BigDecimal outlierThresholdAmount) {
        this.outlierThresholdAmount = outlierThresholdAmount;
    }

    @Generated
    public void setRegularDaysUsed(int regularDaysUsed) {
        this.regularDaysUsed = regularDaysUsed;
    }

    @Generated
    public void setSiteNeutralCostPayment(BigDecimal siteNeutralCostPayment) {
        this.siteNeutralCostPayment = siteNeutralCostPayment;
    }

    @Generated
    public void setSiteNeutralIppsPayment(BigDecimal siteNeutralIppsPayment) {
        this.siteNeutralIppsPayment = siteNeutralIppsPayment;
    }

    @Generated
    public void setStandardFullPayment(BigDecimal standardFullPayment) {
        this.standardFullPayment = standardFullPayment;
    }

    @Generated
    public void setStandardShortStayOutlierPayment(BigDecimal standardShortStayOutlierPayment) {
        this.standardShortStayOutlierPayment = standardShortStayOutlierPayment;
    }

    @Generated
    public void setSubmittedDiagnosisRelatedGroup(String submittedDiagnosisRelatedGroup) {
        this.submittedDiagnosisRelatedGroup = submittedDiagnosisRelatedGroup;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LtchPaymentData)) {
            return false;
        }
        LtchPaymentData other = (LtchPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBlendYear() != other.getBlendYear()) {
            return false;
        }
        if (this.getLengthOfStay() != other.getLengthOfStay()) {
            return false;
        }
        if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) {
            return false;
        }
        if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) {
            return false;
        }
        BigDecimal this$adjustedPayment = this.getAdjustedPayment();
        BigDecimal other$adjustedPayment = other.getAdjustedPayment();
        if (this$adjustedPayment == null ? other$adjustedPayment != null : !((Object)this$adjustedPayment).equals(other$adjustedPayment)) {
            return false;
        }
        BigDecimal this$averageLengthOfStay = this.getAverageLengthOfStay();
        BigDecimal other$averageLengthOfStay = other.getAverageLengthOfStay();
        if (this$averageLengthOfStay == null ? other$averageLengthOfStay != null : !((Object)this$averageLengthOfStay).equals(other$averageLengthOfStay)) {
            return false;
        }
        BigDecimal this$budgetNeutralityRate = this.getBudgetNeutralityRate();
        BigDecimal other$budgetNeutralityRate = other.getBudgetNeutralityRate();
        if (this$budgetNeutralityRate == null ? other$budgetNeutralityRate != null : !((Object)this$budgetNeutralityRate).equals(other$budgetNeutralityRate)) {
            return false;
        }
        String this$changeOfTherapyIndicator = this.getChangeOfTherapyIndicator();
        String other$changeOfTherapyIndicator = other.getChangeOfTherapyIndicator();
        if (this$changeOfTherapyIndicator == null ? other$changeOfTherapyIndicator != null : !this$changeOfTherapyIndicator.equals(other$changeOfTherapyIndicator)) {
            return false;
        }
        BigDecimal this$chargeThresholdAmount = this.getChargeThresholdAmount();
        BigDecimal other$chargeThresholdAmount = other.getChargeThresholdAmount();
        if (this$chargeThresholdAmount == null ? other$chargeThresholdAmount != null : !((Object)this$chargeThresholdAmount).equals(other$chargeThresholdAmount)) {
            return false;
        }
        BigDecimal this$costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
        BigDecimal other$costOfLivingAdjustmentPercent = other.getCostOfLivingAdjustmentPercent();
        if (this$costOfLivingAdjustmentPercent == null ? other$costOfLivingAdjustmentPercent != null : !((Object)this$costOfLivingAdjustmentPercent).equals(other$costOfLivingAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$dischargePaymentPercentAmount = this.getDischargePaymentPercentAmount();
        BigDecimal other$dischargePaymentPercentAmount = other.getDischargePaymentPercentAmount();
        if (this$dischargePaymentPercentAmount == null ? other$dischargePaymentPercentAmount != null : !((Object)this$dischargePaymentPercentAmount).equals(other$dischargePaymentPercentAmount)) {
            return false;
        }
        BigDecimal this$drgRelativeWeight = this.getDrgRelativeWeight();
        BigDecimal other$drgRelativeWeight = other.getDrgRelativeWeight();
        if (this$drgRelativeWeight == null ? other$drgRelativeWeight != null : !((Object)this$drgRelativeWeight).equals(other$drgRelativeWeight)) {
            return false;
        }
        BigDecimal this$facilityCosts = this.getFacilityCosts();
        BigDecimal other$facilityCosts = other.getFacilityCosts();
        if (this$facilityCosts == null ? other$facilityCosts != null : !((Object)this$facilityCosts).equals(other$facilityCosts)) {
            return false;
        }
        BigDecimal this$facilitySpecificRate = this.getFacilitySpecificRate();
        BigDecimal other$facilitySpecificRate = other.getFacilitySpecificRate();
        if (this$facilitySpecificRate == null ? other$facilitySpecificRate != null : !((Object)this$facilitySpecificRate).equals(other$facilitySpecificRate)) {
            return false;
        }
        BigDecimal this$federalPayment = this.getFederalPayment();
        BigDecimal other$federalPayment = other.getFederalPayment();
        if (this$federalPayment == null ? other$federalPayment != null : !((Object)this$federalPayment).equals(other$federalPayment)) {
            return false;
        }
        BigDecimal this$federalRatePercent = this.getFederalRatePercent();
        BigDecimal other$federalRatePercent = other.getFederalRatePercent();
        if (this$federalRatePercent == null ? other$federalRatePercent != null : !((Object)this$federalRatePercent).equals(other$federalRatePercent)) {
            return false;
        }
        BigDecimal this$inpatientThreshold = this.getInpatientThreshold();
        BigDecimal other$inpatientThreshold = other.getInpatientThreshold();
        if (this$inpatientThreshold == null ? other$inpatientThreshold != null : !((Object)this$inpatientThreshold).equals(other$inpatientThreshold)) {
            return false;
        }
        BigDecimal this$nationalLaborPercent = this.getNationalLaborPercent();
        BigDecimal other$nationalLaborPercent = other.getNationalLaborPercent();
        if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !((Object)this$nationalLaborPercent).equals(other$nationalLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
        BigDecimal other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
        if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !((Object)this$nationalNonLaborPercent).equals(other$nationalNonLaborPercent)) {
            return false;
        }
        BigDecimal this$outlierPayment = this.getOutlierPayment();
        BigDecimal other$outlierPayment = other.getOutlierPayment();
        if (this$outlierPayment == null ? other$outlierPayment != null : !((Object)this$outlierPayment).equals(other$outlierPayment)) {
            return false;
        }
        BigDecimal this$outlierThresholdAmount = this.getOutlierThresholdAmount();
        BigDecimal other$outlierThresholdAmount = other.getOutlierThresholdAmount();
        if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !((Object)this$outlierThresholdAmount).equals(other$outlierThresholdAmount)) {
            return false;
        }
        BigDecimal this$siteNeutralCostPayment = this.getSiteNeutralCostPayment();
        BigDecimal other$siteNeutralCostPayment = other.getSiteNeutralCostPayment();
        if (this$siteNeutralCostPayment == null ? other$siteNeutralCostPayment != null : !((Object)this$siteNeutralCostPayment).equals(other$siteNeutralCostPayment)) {
            return false;
        }
        BigDecimal this$siteNeutralIppsPayment = this.getSiteNeutralIppsPayment();
        BigDecimal other$siteNeutralIppsPayment = other.getSiteNeutralIppsPayment();
        if (this$siteNeutralIppsPayment == null ? other$siteNeutralIppsPayment != null : !((Object)this$siteNeutralIppsPayment).equals(other$siteNeutralIppsPayment)) {
            return false;
        }
        BigDecimal this$standardFullPayment = this.getStandardFullPayment();
        BigDecimal other$standardFullPayment = other.getStandardFullPayment();
        if (this$standardFullPayment == null ? other$standardFullPayment != null : !((Object)this$standardFullPayment).equals(other$standardFullPayment)) {
            return false;
        }
        BigDecimal this$standardShortStayOutlierPayment = this.getStandardShortStayOutlierPayment();
        BigDecimal other$standardShortStayOutlierPayment = other.getStandardShortStayOutlierPayment();
        if (this$standardShortStayOutlierPayment == null ? other$standardShortStayOutlierPayment != null : !((Object)this$standardShortStayOutlierPayment).equals(other$standardShortStayOutlierPayment)) {
            return false;
        }
        String this$submittedDiagnosisRelatedGroup = this.getSubmittedDiagnosisRelatedGroup();
        String other$submittedDiagnosisRelatedGroup = other.getSubmittedDiagnosisRelatedGroup();
        return !(this$submittedDiagnosisRelatedGroup == null ? other$submittedDiagnosisRelatedGroup != null : !this$submittedDiagnosisRelatedGroup.equals(other$submittedDiagnosisRelatedGroup));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LtchPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBlendYear();
        result = result * 59 + this.getLengthOfStay();
        result = result * 59 + this.getLifetimeReserveDaysUsed();
        result = result * 59 + this.getRegularDaysUsed();
        BigDecimal $adjustedPayment = this.getAdjustedPayment();
        result = result * 59 + ($adjustedPayment == null ? 43 : ((Object)$adjustedPayment).hashCode());
        BigDecimal $averageLengthOfStay = this.getAverageLengthOfStay();
        result = result * 59 + ($averageLengthOfStay == null ? 43 : ((Object)$averageLengthOfStay).hashCode());
        BigDecimal $budgetNeutralityRate = this.getBudgetNeutralityRate();
        result = result * 59 + ($budgetNeutralityRate == null ? 43 : ((Object)$budgetNeutralityRate).hashCode());
        String $changeOfTherapyIndicator = this.getChangeOfTherapyIndicator();
        result = result * 59 + ($changeOfTherapyIndicator == null ? 43 : $changeOfTherapyIndicator.hashCode());
        BigDecimal $chargeThresholdAmount = this.getChargeThresholdAmount();
        result = result * 59 + ($chargeThresholdAmount == null ? 43 : ((Object)$chargeThresholdAmount).hashCode());
        BigDecimal $costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
        result = result * 59 + ($costOfLivingAdjustmentPercent == null ? 43 : ((Object)$costOfLivingAdjustmentPercent).hashCode());
        BigDecimal $dischargePaymentPercentAmount = this.getDischargePaymentPercentAmount();
        result = result * 59 + ($dischargePaymentPercentAmount == null ? 43 : ((Object)$dischargePaymentPercentAmount).hashCode());
        BigDecimal $drgRelativeWeight = this.getDrgRelativeWeight();
        result = result * 59 + ($drgRelativeWeight == null ? 43 : ((Object)$drgRelativeWeight).hashCode());
        BigDecimal $facilityCosts = this.getFacilityCosts();
        result = result * 59 + ($facilityCosts == null ? 43 : ((Object)$facilityCosts).hashCode());
        BigDecimal $facilitySpecificRate = this.getFacilitySpecificRate();
        result = result * 59 + ($facilitySpecificRate == null ? 43 : ((Object)$facilitySpecificRate).hashCode());
        BigDecimal $federalPayment = this.getFederalPayment();
        result = result * 59 + ($federalPayment == null ? 43 : ((Object)$federalPayment).hashCode());
        BigDecimal $federalRatePercent = this.getFederalRatePercent();
        result = result * 59 + ($federalRatePercent == null ? 43 : ((Object)$federalRatePercent).hashCode());
        BigDecimal $inpatientThreshold = this.getInpatientThreshold();
        result = result * 59 + ($inpatientThreshold == null ? 43 : ((Object)$inpatientThreshold).hashCode());
        BigDecimal $nationalLaborPercent = this.getNationalLaborPercent();
        result = result * 59 + ($nationalLaborPercent == null ? 43 : ((Object)$nationalLaborPercent).hashCode());
        BigDecimal $nationalNonLaborPercent = this.getNationalNonLaborPercent();
        result = result * 59 + ($nationalNonLaborPercent == null ? 43 : ((Object)$nationalNonLaborPercent).hashCode());
        BigDecimal $outlierPayment = this.getOutlierPayment();
        result = result * 59 + ($outlierPayment == null ? 43 : ((Object)$outlierPayment).hashCode());
        BigDecimal $outlierThresholdAmount = this.getOutlierThresholdAmount();
        result = result * 59 + ($outlierThresholdAmount == null ? 43 : ((Object)$outlierThresholdAmount).hashCode());
        BigDecimal $siteNeutralCostPayment = this.getSiteNeutralCostPayment();
        result = result * 59 + ($siteNeutralCostPayment == null ? 43 : ((Object)$siteNeutralCostPayment).hashCode());
        BigDecimal $siteNeutralIppsPayment = this.getSiteNeutralIppsPayment();
        result = result * 59 + ($siteNeutralIppsPayment == null ? 43 : ((Object)$siteNeutralIppsPayment).hashCode());
        BigDecimal $standardFullPayment = this.getStandardFullPayment();
        result = result * 59 + ($standardFullPayment == null ? 43 : ((Object)$standardFullPayment).hashCode());
        BigDecimal $standardShortStayOutlierPayment = this.getStandardShortStayOutlierPayment();
        result = result * 59 + ($standardShortStayOutlierPayment == null ? 43 : ((Object)$standardShortStayOutlierPayment).hashCode());
        String $submittedDiagnosisRelatedGroup = this.getSubmittedDiagnosisRelatedGroup();
        result = result * 59 + ($submittedDiagnosisRelatedGroup == null ? 43 : $submittedDiagnosisRelatedGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LtchPaymentData(adjustedPayment=" + this.getAdjustedPayment() + ", averageLengthOfStay=" + this.getAverageLengthOfStay() + ", blendYear=" + this.getBlendYear() + ", budgetNeutralityRate=" + this.getBudgetNeutralityRate() + ", changeOfTherapyIndicator=" + this.getChangeOfTherapyIndicator() + ", chargeThresholdAmount=" + this.getChargeThresholdAmount() + ", costOfLivingAdjustmentPercent=" + this.getCostOfLivingAdjustmentPercent() + ", dischargePaymentPercentAmount=" + this.getDischargePaymentPercentAmount() + ", drgRelativeWeight=" + this.getDrgRelativeWeight() + ", facilityCosts=" + this.getFacilityCosts() + ", facilitySpecificRate=" + this.getFacilitySpecificRate() + ", federalPayment=" + this.getFederalPayment() + ", federalRatePercent=" + this.getFederalRatePercent() + ", inpatientThreshold=" + this.getInpatientThreshold() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ", siteNeutralCostPayment=" + this.getSiteNeutralCostPayment() + ", siteNeutralIppsPayment=" + this.getSiteNeutralIppsPayment() + ", standardFullPayment=" + this.getStandardFullPayment() + ", standardShortStayOutlierPayment=" + this.getStandardShortStayOutlierPayment() + ", submittedDiagnosisRelatedGroup=" + this.getSubmittedDiagnosisRelatedGroup() + ")";
    }

    @Generated
    public LtchPaymentData() {
    }
}

