/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.models.LtchWageIndexTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class AssemblePpsVariables
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        LtchWageIndexTableEntry ltchWageIndexTableEntry = calculationContext.getLtchWageIndexTableEntry();
        BigDecimal ltchWageIndex3 = ltchWageIndexTableEntry.getLtchWageIndex3();
        if (ltchWageIndex3 == null || !BigDecimalUtils.isGreaterThanZero(ltchWageIndex3)) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
            return;
        }
        paymentData.setFinalWageIndex(ltchWageIndex3);
        this.assembleBlendVariables(paymentData, calculationContext);
    }

    private void assembleBlendVariables(LtchPaymentData paymentData, LtchPricerContext calculationContext) {
        LtchClaimData claimData = calculationContext.getClaimData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        int blendYear = Integer.parseInt(providerData.getFederalPpsBlend());
        if (StringUtils.equals(claimData.getReviewCode(), "00")) {
            blendYear = 5;
        }
        paymentData.setBlendYear(blendYear);
        Integer reviewCode = calculationContext.getReviewCodeAsInt();
        if (reviewCode >= 1 && reviewCode <= 8 && (blendYear > 8 || blendYear < 6)) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_BLEND_IND_OR_REVIEW_CODE_72);
            return;
        }
        calculationContext.setHoldBlendSiteNeutral(BigDecimal.ZERO);
        calculationContext.setHoldBlendStandard(BigDecimal.ONE.setScale(1, RoundingMode.HALF_UP));
        calculationContext.setHoldBlendRtc(BigDecimal.ZERO);
        if (StringUtils.equalsAny(providerData.getStateCode(), "02", "12")) {
            paymentData.setCostOfLivingAdjustmentPercent(providerData.getCostOfLivingAdjustment());
        } else {
            paymentData.setCostOfLivingAdjustmentPercent(BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP));
        }
    }
}

