/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.RoundingMode;

public class CalculateFacilityCosts
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        paymentData.setFacilityCosts(providerData.getOperatingCostToChargeRatio().multiply(claimData.getCoveredCharges()).setScale(2, RoundingMode.HALF_UP));
    }
}

