/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CapLtchWageIndexDecrease
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        if ("1".equals(calculationContext.getSupplementalWageIndexIndicator())) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getSupplementalWageIndex())) {
                BigDecimal supplementalWageIndexRatio = calculationContext.getLtchWageIndexTableEntry().getLtchWageIndex3().subtract(calculationContext.getSupplementalWageIndex()).divide(calculationContext.getSupplementalWageIndex(), RoundingMode.HALF_UP);
                if (BigDecimalUtils.isLessThan(supplementalWageIndexRatio, new BigDecimal("-0.05"))) {
                    BigDecimal ltchWageIndexCap = calculationContext.getProviderData().getSupplementalWageIndex().multiply(new BigDecimal("0.95")).setScale(4, RoundingMode.HALF_UP);
                    calculationContext.getLtchWageIndexTableEntry().setLtchWageIndex3(ltchWageIndexCap);
                    calculationContext.getPaymentData().setFinalWageIndex(ltchWageIndexCap);
                } else {
                    calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
                }
            } else {
                calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
            }
        }
    }

    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return !"1".equals(calculationContext.getProviderData().getSpecialPaymentIndicator());
    }
}

