/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v1.LtchDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class EditDrgCode
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        String drgCode = claimData.getDiagnosisRelatedGroup();
        paymentData.setSubmittedDiagnosisRelatedGroup(drgCode);
        LtchDrgsTableEntry entry = calculationContext.getDataTables().getLtchDrgsEntry(drgCode);
        if (entry == null) {
            calculationContext.applyReturnCode(ReturnCode.DRG_NOT_FOUND_54);
        } else {
            paymentData.setDrgRelativeWeight(entry.getRelativeWeight());
            paymentData.setAverageLengthOfStay(entry.getArithmeticMeanLengthOfStay());
        }
        Integer coveredDays = claimData.getCoveredDays();
        BigDecimal averageLengthOfStay = paymentData.getAverageLengthOfStay();
        if (claimData.getLengthOfStay() != 1 && claimData.getCoveredDays() <= claimData.getLengthOfStay() && this.isCoveredDaysLessThanOrEqualToTruncatedAverage(coveredDays, averageLengthOfStay)) {
            paymentData.setLengthOfStay(claimData.getCoveredDays());
            calculationContext.setHoldLengthOfStay(BigDecimal.valueOf(claimData.getLengthOfStay().intValue()));
        }
    }

    private boolean isCoveredDaysLessThanOrEqualToTruncatedAverage(Integer coveredDays, BigDecimal averageLengthOfStay) {
        return BigDecimalUtils.isLessThanOrEqualTo(BigDecimal.valueOf(coveredDays.intValue()), averageLengthOfStay.divide(new BigDecimal("6"), new MathContext(10)).multiply(new BigDecimal("5")).setScale(1, RoundingMode.HALF_UP));
    }
}

