/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class EditInputData
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        this.validateInputData(calculationContext);
    }

    private void validateInputData(LtchPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        if (claimData.getLengthOfStay() > 0) {
            calculationContext.setHoldLengthOfStay(BigDecimal.valueOf(claimData.getLengthOfStay().intValue()));
            paymentData.setLengthOfStay(claimData.getLengthOfStay());
        } else {
            calculationContext.applyReturnCode(ReturnCode.INVALID_LOS_56);
        }
        if ("Y".equals(providerData.getWaiverIndicator())) {
            calculationContext.applyReturnCode(ReturnCode.WAIVER_STATE_NOT_CALC_53);
        }
        if (LocalDateUtils.isBefore(claimData.getDischargeDate(), providerData.getEffectiveDate())) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_DISCHARGE_DATE_55);
        }
        if (this.isProviderRecordTerminationDateInvalid(providerData, claimData)) {
            calculationContext.applyReturnCode(ReturnCode.PROV_RECORD_TERM_51);
        }
        if (this.isLifetimeReserveDaysInvalid(claimData)) {
            calculationContext.applyReturnCode(ReturnCode.LIFETIME_RESERVE_DAYS_NOT_NUM_OR_GR_60_61);
        }
        if (this.isCoveredDaysInvalid(paymentData, claimData)) {
            calculationContext.applyReturnCode(ReturnCode.COV_DAYS_NOT_NUM_OR_LT_LIFETIME_RESERVE_DAYS_62);
        }
        if (this.isReviewCodeInvalid(calculationContext)) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_BLEND_IND_OR_REVIEW_CODE_72);
        }
        if (StringUtils.equals(ReturnCode.NORMAL_DRG_00.getCode(), calculationContext.getReturnCode())) {
            calculationContext.setHoldRegularDays(claimData.getCoveredDays() - claimData.getLifetimeReserveDays());
            calculationContext.setHoldTotalDays(calculationContext.getHoldRegularDays() + claimData.getLifetimeReserveDays());
            this.daysUsed(calculationContext);
        }
        if (LocalDateUtils.isBefore(calculationContext.getFyBegin(), LocalDate.of(2002, 10, 1))) {
            calculationContext.applyReturnCode(ReturnCode.PROV_FY_BEGIN_DATE_BEFORE_10_01_2002_74);
        }
        if (providerData.getCapitalIndirectMedicalEducationRatio() != null) {
            calculationContext.setHoldCapitalTeachingAdjustmentRatio(providerData.getCapitalIndirectMedicalEducationRatio());
        } else {
            calculationContext.setHoldCapitalTeachingAdjustmentRatio(BigDecimal.ZERO);
        }
        calculationContext.setHoldBedSize(BigDecimal.valueOf(providerData.getBedSize().intValue()));
    }

    private boolean isProviderRecordTerminationDateInvalid(InpatientProviderData providerData, LtchClaimData claimData) {
        return providerData.getTerminationDate() != null && providerData.getTerminationDate().isBefore(claimData.getDischargeDate());
    }

    private boolean isLifetimeReserveDaysInvalid(LtchClaimData claimData) {
        return claimData.getLifetimeReserveDays() > 60;
    }

    private boolean isCoveredDaysInvalid(LtchPaymentData paymentData, LtchClaimData claimData) {
        return claimData.getCoveredDays() == 0 && paymentData.getLengthOfStay() > 0 || claimData.getLifetimeReserveDays() > claimData.getCoveredDays();
    }

    private boolean isReviewCodeInvalid(LtchPricerContext calculationContext) {
        return calculationContext.getClaimData().getReviewCode() == null || calculationContext.getReviewCodeAsInt() < 0 || calculationContext.getReviewCodeAsInt() > 8;
    }

    private void daysUsed(LtchPricerContext calculationContext) {
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        int lifeTimeReserveDays = claimData.getLifetimeReserveDays();
        int coveredDays = claimData.getCoveredDays();
        int holdRegularDays = coveredDays - lifeTimeReserveDays;
        if (lifeTimeReserveDays > 0 && holdRegularDays == 0) {
            paymentData.setLifetimeReserveDaysUsed(Math.min(lifeTimeReserveDays, calculationContext.getHoldLengthOfStay().intValue()));
        } else if (holdRegularDays > 0 && lifeTimeReserveDays == 0) {
            paymentData.setRegularDaysUsed(Math.min(holdRegularDays, calculationContext.getHoldLengthOfStay().intValue()));
            paymentData.setLifetimeReserveDaysUsed(0);
        } else if (holdRegularDays > 0 && lifeTimeReserveDays > 0) {
            if (holdRegularDays > calculationContext.getHoldLengthOfStay().intValue()) {
                paymentData.setRegularDaysUsed(calculationContext.getHoldLengthOfStay().intValue());
                paymentData.setLifetimeReserveDaysUsed(0);
            } else if (calculationContext.getHoldTotalDays() > calculationContext.getHoldLengthOfStay().intValue()) {
                paymentData.setRegularDaysUsed(calculationContext.getHoldRegularDays());
                paymentData.setLifetimeReserveDaysUsed(calculationContext.getHoldLengthOfStay().intValue() - calculationContext.getHoldRegularDays());
            } else if (calculationContext.getHoldTotalDays() <= calculationContext.getHoldLengthOfStay().intValue()) {
                paymentData.setRegularDaysUsed(calculationContext.getHoldRegularDays());
                paymentData.setLifetimeReserveDaysUsed(claimData.getLifetimeReserveDays());
            }
        }
    }
}

