/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;

public class SetNewReturnCodes
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        if (!ErrorCode.isErrorCode(calculationContext.getReturnCode()) && calculationContext.isPaymentStandardNewSiteNeutralOrBlendTypes()) {
            this.setNewReturnCodes(calculationContext);
        }
    }

    private void setNewReturnCodes(LtchPricerContext calculationContext) {
        boolean ventilatorServicePresent;
        LtchClaimData claimData = calculationContext.getClaimData();
        calculationContext.setReturnCodePart1("C");
        boolean bl = ventilatorServicePresent = claimData.getProcedureCodes() != null && claimData.getProcedureCodes().contains(calculationContext.getVentilationIcd10Code());
        if (ventilatorServicePresent) {
            calculationContext.setReturnCodePart1("B");
        }
        if (calculationContext.isPsychRehabDrg() && calculationContext.isPaymentBlendOrSiteNeutral()) {
            calculationContext.setReturnCodePart1("A");
        }
        this.setNewReturnCodesBlendAndSiteNeutralCost(calculationContext);
        this.setNewReturnCodesBlendAndSiteNeutralIpps(calculationContext);
        this.setNewReturnCodesSiteNeutral(calculationContext);
        this.setNewReturnCodesStandardNew(calculationContext);
        calculationContext.applyReturnCodeFromTwoPartCode();
    }

    private void setNewReturnCodesBlendAndSiteNeutralCost(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
        if (paymentType.equals((Object)PaymentType.BLEND) && secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.COST)) {
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("0");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("1");
            }
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("2");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("3");
            }
        }
    }

    private void setNewReturnCodesBlendAndSiteNeutralIpps(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
        if (paymentType.equals((Object)PaymentType.BLEND) && secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.IPPS)) {
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("4");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("5");
            }
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("6");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("7");
            }
        }
    }

    private void setNewReturnCodesSiteNeutral(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        if (paymentType.equals((Object)PaymentType.SITE_NEUTRAL)) {
            if (secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.COST)) {
                calculationContext.setReturnCodePart2("A");
            }
            if (secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.IPPS)) {
                if (BigDecimalUtils.isZero(paymentData.getOutlierPayment())) {
                    calculationContext.setReturnCodePart2("B");
                } else {
                    calculationContext.setReturnCodePart2("C");
                }
            }
        }
    }

    private void setNewReturnCodesStandardNew(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
        if (paymentType.equals((Object)PaymentType.STANDARD_NEW)) {
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("D");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.SSO)) {
                calculationContext.setReturnCodePart2("E");
            }
            if (BigDecimalUtils.isZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("F");
            }
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                calculationContext.setReturnCodePart2("G");
            }
        }
    }
}

