/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.time.LocalDate;

public class SupplementalWageIndexEdit
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return !"1".equals(calculationContext.getProviderData().getSpecialPaymentIndicator());
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        String supplementalWageIndexIndicator = calculationContext.getProviderData().getSupplementalWageIndexIndicator();
        BigDecimal supplementalWageIndex = calculationContext.getProviderData().getSupplementalWageIndex();
        if (("1".equals(supplementalWageIndexIndicator) || "2".equals(supplementalWageIndexIndicator)) && BigDecimalUtils.isLessThanOrEqualToZero(supplementalWageIndex)) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
            return;
        }
        LocalDate effectiveDate = calculationContext.getProviderData().getEffectiveDate();
        if (("1".equals(supplementalWageIndexIndicator) || "2".equals(supplementalWageIndexIndicator)) && (LocalDateUtils.isBefore(effectiveDate, calculationContext.getFyBegin()) || LocalDateUtils.isAfter(effectiveDate, calculationContext.getFyEnd()))) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
        }
    }
}

