/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=WageIppsIndexRuralEntryBuilder.class)
@JsonPropertyOrder(value={"cbsa", "effectiveDate", "wageIndex"})
@Immutable
public class WageIppsIndexRuralEntry {
    private final String cbsa;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;
    @Digits(integer=2, fraction=4)
    private final @Digits(integer=2, fraction=4) BigDecimal wageIndex;
    public static final WageIppsIndexRuralEntryBuilder DEFAULT = WageIppsIndexRuralEntry.builder().cbsa("   00").wageIndex(BigDecimalUtils.ZERO);

    @JsonIgnore
    public String getCbsaPadded() {
        return StringUtils.leftPad(this.cbsa, 5, ' ');
    }

    public WageIppsIndexRuralEntryBuilder copyBuilder() {
        return WageIppsIndexRuralEntry.builder().cbsa(this.getCbsa()).effectiveDate(this.getEffectiveDate()).wageIndex(this.getWageIndex());
    }

    @Generated
    WageIppsIndexRuralEntry(String cbsa, LocalDate effectiveDate, BigDecimal wageIndex) {
        this.cbsa = cbsa;
        this.effectiveDate = effectiveDate;
        this.wageIndex = wageIndex;
    }

    @Generated
    public static WageIppsIndexRuralEntryBuilder builder() {
        return new WageIppsIndexRuralEntryBuilder();
    }

    @Generated
    public String getCbsa() {
        return this.cbsa;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getWageIndex() {
        return this.wageIndex;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class WageIppsIndexRuralEntryBuilder {
        @Generated
        private String cbsa;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal wageIndex;

        @Generated
        WageIppsIndexRuralEntryBuilder() {
        }

        @Generated
        public WageIppsIndexRuralEntryBuilder cbsa(String cbsa) {
            this.cbsa = cbsa;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public WageIppsIndexRuralEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public WageIppsIndexRuralEntryBuilder wageIndex(BigDecimal wageIndex) {
            this.wageIndex = wageIndex;
            return this;
        }

        @Generated
        public WageIppsIndexRuralEntry build() {
            return new WageIppsIndexRuralEntry(this.cbsa, this.effectiveDate, this.wageIndex);
        }

        @Generated
        public String toString() {
            return "WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder(cbsa=" + this.cbsa + ", effectiveDate=" + this.effectiveDate + ", wageIndex=" + this.wageIndex + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String CBSA = "cbsa";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String WAGE_INDEX = "wageIndex";
    }
}

