/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class WageIppsIndexRuralLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/rufl.csv";
    private final CsvContentReader<WageIppsIndexRuralEntry> contentProvider = new CsvContentReader<WageIppsIndexRuralEntry>(WageIppsIndexRuralEntry.class);

    public WageIppsIndexRuralLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> generate() {
        return this.generate(CSV_FILE_PATTERN);
    }

    public Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> generate(String csvFile) {
        List<WageIppsIndexRuralEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<WageIppsIndexRuralEntry, ?, NavigableMap> collector = Collectors.toMap(WageIppsIndexRuralEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(WageIppsIndexRuralEntry::getCbsa, content, HashMap::new, collector);
    }
}

