/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;

public class AtomicReferenceArrayElementComparisonStrategy<T>
extends StandardComparisonStrategy {
    private final Comparator<? super T> elementComparator;

    public AtomicReferenceArrayElementComparisonStrategy(Comparator<? super T> elementComparator) {
        this.elementComparator = elementComparator;
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        if (actual == null && other == null) {
            return true;
        }
        if (actual == null || other == null) {
            return false;
        }
        return actual instanceof AtomicReferenceArray && Arrays.isArray(other) && this.compareElementsOf((AtomicReferenceArray)actual, (Object[])other);
    }

    private boolean compareElementsOf(AtomicReferenceArray<T> actual, T[] other) {
        if (actual.length() != other.length) {
            return false;
        }
        for (int i2 = 0; i2 < actual.length(); ++i2) {
            if (this.elementComparator.compare(actual.get(i2), other[i2]) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "AtomicReferenceArrayElementComparisonStrategy using " + ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this.elementComparator);
    }

    @Override
    public String asText() {
        return "when comparing elements using " + ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this.elementComparator);
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

