// Generated by delombok at Mon Sep 30 19:32:03 UTC 2024
package gov.cms.fiss.pricers.ltch.api.v1;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gov.cms.fiss.pricers.common.api.serialization.StrictIsoLocalDateDeserializer;
import gov.cms.fiss.pricers.common.api.serialization.StrictIsoLocalDateSerializer;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry.Fields;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Immutable
@JsonDeserialize(builder = InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder.class)
@JsonPropertyOrder({Fields.DIAGNOSTIC_RELATED_GROUP, Fields.EFFECTIVE_DATE, Fields.WEIGHT, Fields.GEOMETRIC_MEAN_LENGTH_OF_STAY, Fields.LOW_VOLUME_DRG, Fields.ARITHMETIC_MEAN_LENGTH_OF_STAY, Fields.POST_ACUTE_CARE, Fields.SPECIAL_PAYMENT_POST_ACUTE_CARE, Fields.DESCRIPTION})
@Schema(description = "The inpatient diagnostic-related group (DRG) information.")
public class InpatientDrgsTableEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class InpatientDrgsTableEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal arithmeticMeanLengthOfStay;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String description;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String diagnosticRelatedGroup;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private LocalDate effectiveDate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal geometricMeanLengthOfStay;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String lowVolumeDrg;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String postAcuteCare;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String specialPaymentPostAcuteCare;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal weight;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    InpatientDrgsTableEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder arithmeticMeanLengthOfStay(final BigDecimal arithmeticMeanLengthOfStay) {
      this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder description(final String description) {
      this.description = description;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder diagnosticRelatedGroup(final String diagnosticRelatedGroup) {
      this.diagnosticRelatedGroup = diagnosticRelatedGroup;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @JsonDeserialize(using = StrictIsoLocalDateDeserializer.class)
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder effectiveDate(final LocalDate effectiveDate) {
      this.effectiveDate = effectiveDate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder geometricMeanLengthOfStay(final BigDecimal geometricMeanLengthOfStay) {
      this.geometricMeanLengthOfStay = geometricMeanLengthOfStay;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder lowVolumeDrg(final String lowVolumeDrg) {
      this.lowVolumeDrg = lowVolumeDrg;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder postAcuteCare(final String postAcuteCare) {
      this.postAcuteCare = postAcuteCare;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder specialPaymentPostAcuteCare(final String specialPaymentPostAcuteCare) {
      this.specialPaymentPostAcuteCare = specialPaymentPostAcuteCare;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder weight(final BigDecimal weight) {
      this.weight = weight;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InpatientDrgsTableEntry build() {
      return new InpatientDrgsTableEntry(this.arithmeticMeanLengthOfStay, this.description, this.diagnosticRelatedGroup, this.effectiveDate, this.geometricMeanLengthOfStay, this.lowVolumeDrg, this.postAcuteCare, this.specialPaymentPostAcuteCare, this.weight);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder(arithmeticMeanLengthOfStay=" + this.arithmeticMeanLengthOfStay + ", description=" + this.description + ", diagnosticRelatedGroup=" + this.diagnosticRelatedGroup + ", effectiveDate=" + this.effectiveDate + ", geometricMeanLengthOfStay=" + this.geometricMeanLengthOfStay + ", lowVolumeDrg=" + this.lowVolumeDrg + ", postAcuteCare=" + this.postAcuteCare + ", specialPaymentPostAcuteCare=" + this.specialPaymentPostAcuteCare + ", weight=" + this.weight + ")";
    }
  }

  @DecimalMax("99.9")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 1)
  @NotNull
  @Schema(description = "Arithmetic mean length of stay.", example = "1.2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-ARITH-ALOS", value = "PIC 9(02)V9(01)")})})
  private final BigDecimal arithmeticMeanLengthOfStay;
  @NotNull
  @Schema(description = "Group description.", example = "TRANSIENT ISCHEMIA W/O THR", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-DESC", value = "PIC X(26)")})})
  private final String description;
  @NotNull
  @Pattern(regexp = "\\d{3}")
  @Schema(description = "Diagnostic-related group.", example = "077", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WK-DRG-DRGX", value = "PIC X(03)")})})
  private final String diagnosticRelatedGroup;
  @JsonDeserialize(using = StrictIsoLocalDateDeserializer.class)
  @JsonSerialize(using = StrictIsoLocalDateSerializer.class)
  @Schema(description = "Effective date of DRG information.", example = "2018-10-01", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WK-DRGX-EFF-DATE", value = "PIC X(08)")})})
  private final LocalDate effectiveDate;
  @DecimalMax("99.9")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 1)
  @Schema(description = "Geometric mean length of stay.", example = "23.4", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-GMALOS", value = "PIC 9(02)V9(01)")})})
  private final BigDecimal geometricMeanLengthOfStay;
  @Schema(description = "Low-volume diagnostic-related group indicator.", example = "077", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-LOW", value = "PIC X(01)")})})
  private final String lowVolumeDrg;
  @Pattern(regexp = "Y?")
  @Schema(description = "Post-acute care indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-PAC", value = "PIC X(01)")})})
  private final String postAcuteCare;
  @Pattern(regexp = "Y?")
  @Schema(description = "Special payment post-acute care indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-SPPAC", value = "PIC X(01)")})})
  private final String specialPaymentPostAcuteCare;
  @DecimalMax("99.9999")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 4)
  @Schema(description = "Group weight.", example = "3.3326", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "DRG-WEIGHT", value = "PIC 9(02)V9(04)")})})
  private final BigDecimal weight;

  public InpatientDrgsTableEntryBuilder copyBuilder() {
    return InpatientDrgsTableEntry.builder().arithmeticMeanLengthOfStay(getArithmeticMeanLengthOfStay()).description(getDescription()).diagnosticRelatedGroup(getDiagnosticRelatedGroup()).effectiveDate(getEffectiveDate()).geometricMeanLengthOfStay(getGeometricMeanLengthOfStay()).lowVolumeDrg(getLowVolumeDrg()).postAcuteCare(getPostAcuteCare()).specialPaymentPostAcuteCare(getSpecialPaymentPostAcuteCare()).weight(getWeight());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  InpatientDrgsTableEntry(final BigDecimal arithmeticMeanLengthOfStay, final String description, final String diagnosticRelatedGroup, final LocalDate effectiveDate, final BigDecimal geometricMeanLengthOfStay, final String lowVolumeDrg, final String postAcuteCare, final String specialPaymentPostAcuteCare, final BigDecimal weight) {
    this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
    this.description = description;
    this.diagnosticRelatedGroup = diagnosticRelatedGroup;
    this.effectiveDate = effectiveDate;
    this.geometricMeanLengthOfStay = geometricMeanLengthOfStay;
    this.lowVolumeDrg = lowVolumeDrg;
    this.postAcuteCare = postAcuteCare;
    this.specialPaymentPostAcuteCare = specialPaymentPostAcuteCare;
    this.weight = weight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder builder() {
    return new InpatientDrgsTableEntry.InpatientDrgsTableEntryBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getArithmeticMeanLengthOfStay() {
    return this.arithmeticMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosticRelatedGroup() {
    return this.diagnosticRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getGeometricMeanLengthOfStay() {
    return this.geometricMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLowVolumeDrg() {
    return this.lowVolumeDrg;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPostAcuteCare() {
    return this.postAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSpecialPaymentPostAcuteCare() {
    return this.specialPaymentPostAcuteCare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWeight() {
    return this.weight;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String ARITHMETIC_MEAN_LENGTH_OF_STAY = "arithmeticMeanLengthOfStay";
    public static final java.lang.String DESCRIPTION = "description";
    public static final java.lang.String DIAGNOSTIC_RELATED_GROUP = "diagnosticRelatedGroup";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String GEOMETRIC_MEAN_LENGTH_OF_STAY = "geometricMeanLengthOfStay";
    public static final java.lang.String LOW_VOLUME_DRG = "lowVolumeDrg";
    public static final java.lang.String POST_ACUTE_CARE = "postAcuteCare";
    public static final java.lang.String SPECIAL_PAYMENT_POST_ACUTE_CARE = "specialPaymentPostAcuteCare";
    public static final java.lang.String WEIGHT = "weight";
  }
}
